/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.meta.PsiPresentableMetaData;
import javax.swing.Icon;

public class ComputableIcon {
    private Icon myIcon;
    private Computable<Icon> myEvaluator;
    private boolean myEvaluated;

    public ComputableIcon(Computable<Icon> evaluator) {
        this.myEvaluator = evaluator;
    }

    public Icon getIcon() {
        if (!this.myEvaluated) {
            this.myIcon = (Icon)this.myEvaluator.compute();
            this.myEvaluator = null;
            this.myEvaluated = true;
        }
        return this.myIcon;
    }

    public static ComputableIcon create(Icon icon) {
        return new ComputableIcon((Computable<Icon>)((Computable)() -> icon));
    }

    public static ComputableIcon create(ItemPresentation presentation, boolean isOpen) {
        return new ComputableIcon((Computable<Icon>)((Computable)() -> presentation.getIcon(isOpen)));
    }

    public static ComputableIcon create(PsiPresentableMetaData data) {
        return new ComputableIcon((Computable<Icon>)((Computable)() -> data.getIcon()));
    }

    public static ComputableIcon create(VirtualFile file) {
        return new ComputableIcon((Computable<Icon>)((Computable)() -> VirtualFilePresentation.getIcon(file)));
    }
}

