/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.LightProjectDescriptor;
import org.jetbrains.annotations.NotNull;

public class DefaultLightProjectDescriptor
extends LightProjectDescriptor {
    @NotNull
    public ModuleType getModuleType() {
        ModuleType moduleType = StdModuleTypes.JAVA;
        if (moduleType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/DefaultLightProjectDescriptor", "getModuleType"));
        }
        return moduleType;
    }

    public Sdk getSdk() {
        return IdeaTestUtil.getMockJdk17();
    }

    public void configureModule(@NotNull Module module, @NotNull ModifiableRootModel model, @NotNull ContentEntry contentEntry) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/testFramework/fixtures/DefaultLightProjectDescriptor", "configureModule"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/testFramework/fixtures/DefaultLightProjectDescriptor", "configureModule"));
        }
        if (contentEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntry", "com/intellij/testFramework/fixtures/DefaultLightProjectDescriptor", "configureModule"));
        }
        LanguageLevelModuleExtension extension = model.getModuleExtension(LanguageLevelModuleExtension.class);
        if (extension != null) {
            extension.setLanguageLevel(LanguageLevel.HIGHEST);
        }
    }
}

