/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskNotification;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectTaskManager {
    @NotNull
    protected final Project myProject;

    public ProjectTaskManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/task/ProjectTaskManager", "<init>"));
        }
        this.myProject = project;
    }

    public static ProjectTaskManager getInstance(Project project) {
        return ServiceManager.getService(project, ProjectTaskManager.class);
    }

    public abstract void run(@NotNull ProjectTask var1, @Nullable ProjectTaskNotification var2);

    public abstract void run(@NotNull ProjectTaskContext var1, @NotNull ProjectTask var2, @Nullable ProjectTaskNotification var3);

    public abstract void buildAllModules(@Nullable ProjectTaskNotification var1);

    public void buildAllModules() {
        this.buildAllModules(null);
    }

    public abstract void rebuildAllModules(@Nullable ProjectTaskNotification var1);

    public void rebuildAllModules() {
        this.rebuildAllModules(null);
    }

    public abstract void build(@NotNull Module[] var1, @Nullable ProjectTaskNotification var2);

    public void build(Module ... modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/task/ProjectTaskManager", "build"));
        }
        this.build(modules, (ProjectTaskNotification)null);
    }

    public abstract void rebuild(@NotNull Module[] var1, @Nullable ProjectTaskNotification var2);

    public void rebuild(Module ... modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/task/ProjectTaskManager", "rebuild"));
        }
        this.rebuild(modules, (ProjectTaskNotification)null);
    }

    public abstract void compile(@NotNull VirtualFile[] var1, @Nullable ProjectTaskNotification var2);

    public void compile(VirtualFile ... files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/task/ProjectTaskManager", "compile"));
        }
        this.compile(files, (ProjectTaskNotification)null);
    }

    public abstract void build(@NotNull Artifact[] var1, @Nullable ProjectTaskNotification var2);

    public void build(@NotNull Artifact[] artifacts) {
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/intellij/task/ProjectTaskManager", "build"));
        }
        this.build(artifacts, null);
    }

    public abstract void rebuild(@NotNull Artifact[] var1, @Nullable ProjectTaskNotification var2);

    public void rebuild(Artifact ... artifacts) {
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/intellij/task/ProjectTaskManager", "rebuild"));
        }
        this.rebuild(artifacts, (ProjectTaskNotification)null);
    }

    public abstract ProjectTask createAllModulesBuildTask(boolean var1, Project var2);

    public abstract ProjectTask createModulesBuildTask(Module var1, boolean var2, boolean var3, boolean var4);

    public abstract ProjectTask createModulesBuildTask(Module[] var1, boolean var2, boolean var3, boolean var4);

    public abstract ProjectTask createArtifactsBuildTask(boolean var1, Artifact ... var2);
}

