/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.TodoAttributes;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TodoPattern
implements Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.search.TodoPattern");
    private IndexPattern myIndexPattern;
    private TodoAttributes myAttributes;
    @NonNls
    private static final String CASE_SENS_ATT = "case-sensitive";
    @NonNls
    private static final String PATTERN_ATT = "pattern";

    public TodoPattern(@NotNull TodoAttributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/psi/search/TodoPattern", "<init>"));
        }
        this("", attributes, false);
    }

    public TodoPattern(@NotNull Element state, @NotNull TextAttributes defaultTodoAttributes) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/search/TodoPattern", "<init>"));
        }
        if (defaultTodoAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultTodoAttributes", "com/intellij/psi/search/TodoPattern", "<init>"));
        }
        this.myAttributes = new TodoAttributes(state, defaultTodoAttributes);
        this.myIndexPattern = new IndexPattern(state.getAttributeValue(PATTERN_ATT, "").trim(), Boolean.parseBoolean(state.getAttributeValue(CASE_SENS_ATT)));
    }

    public TodoPattern(@NotNull String patternString, @NotNull TodoAttributes attributes, boolean caseSensitive) {
        if (patternString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternString", "com/intellij/psi/search/TodoPattern", "<init>"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/psi/search/TodoPattern", "<init>"));
        }
        this.myIndexPattern = new IndexPattern(patternString, caseSensitive);
        this.myAttributes = attributes;
    }

    public TodoPattern clone() {
        try {
            TodoAttributes attributes = this.myAttributes.clone();
            TodoPattern pattern = (TodoPattern)super.clone();
            pattern.myIndexPattern = new IndexPattern(this.myIndexPattern.getPatternString(), this.myIndexPattern.isCaseSensitive());
            pattern.myAttributes = attributes;
            return pattern;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @NotNull
    public String getPatternString() {
        String string = this.myIndexPattern.getPatternString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/TodoPattern", "getPatternString"));
        }
        return string;
    }

    public void setPatternString(@NotNull String patternString) {
        if (patternString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternString", "com/intellij/psi/search/TodoPattern", "setPatternString"));
        }
        this.myIndexPattern.setPatternString(patternString);
    }

    @NotNull
    public TodoAttributes getAttributes() {
        TodoAttributes todoAttributes = this.myAttributes;
        if (todoAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/TodoPattern", "getAttributes"));
        }
        return todoAttributes;
    }

    public void setAttributes(@NotNull TodoAttributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/psi/search/TodoPattern", "setAttributes"));
        }
        this.myAttributes = attributes;
    }

    public boolean isCaseSensitive() {
        return this.myIndexPattern.isCaseSensitive();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.myIndexPattern.setCaseSensitive(caseSensitive);
    }

    public Pattern getPattern() {
        return this.myIndexPattern.getPattern();
    }

    public void writeExternal(Element element) {
        this.myAttributes.writeExternal(element);
        if (this.myIndexPattern.isCaseSensitive()) {
            element.setAttribute(CASE_SENS_ATT, "true");
        }
        element.setAttribute(PATTERN_ATT, this.myIndexPattern.getPatternString());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TodoPattern)) {
            return false;
        }
        TodoPattern pattern = (TodoPattern)obj;
        if (!this.myIndexPattern.equals(pattern.myIndexPattern)) {
            return false;
        }
        return Comparing.equal((Object)this.myAttributes, (Object)pattern.myAttributes);
    }

    public int hashCode() {
        return this.myIndexPattern.hashCode();
    }

    public IndexPattern getIndexPattern() {
        return this.myIndexPattern;
    }
}

