/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.match;

import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import org.jetbrains.annotations.NotNull;

public class ArrangementMatchRule {
    @NotNull
    public static final ArrangementSettingsToken DEFAULT_ORDER_TYPE = StdArrangementTokens.Order.KEEP;
    @NotNull
    private final ArrangementEntryMatcher myMatcher;
    @NotNull
    private final ArrangementSettingsToken myOrderType;

    public ArrangementMatchRule(@NotNull ArrangementEntryMatcher matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/psi/codeStyle/arrangement/match/ArrangementMatchRule", "<init>"));
        }
        this(matcher, DEFAULT_ORDER_TYPE);
    }

    public ArrangementMatchRule(@NotNull ArrangementEntryMatcher matcher, @NotNull ArrangementSettingsToken orderType) {
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/psi/codeStyle/arrangement/match/ArrangementMatchRule", "<init>"));
        }
        if (orderType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderType", "com/intellij/psi/codeStyle/arrangement/match/ArrangementMatchRule", "<init>"));
        }
        this.myMatcher = matcher;
        this.myOrderType = orderType;
    }

    @NotNull
    public ArrangementEntryMatcher getMatcher() {
        ArrangementEntryMatcher arrangementEntryMatcher = this.myMatcher;
        if (arrangementEntryMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/match/ArrangementMatchRule", "getMatcher"));
        }
        return arrangementEntryMatcher;
    }

    @NotNull
    public ArrangementSettingsToken getOrderType() {
        ArrangementSettingsToken arrangementSettingsToken = this.myOrderType;
        if (arrangementSettingsToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/match/ArrangementMatchRule", "getOrderType"));
        }
        return arrangementSettingsToken;
    }

    public int hashCode() {
        int result = this.myMatcher.hashCode();
        result = 31 * result + this.myOrderType.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrangementMatchRule that = (ArrangementMatchRule)o;
        return this.myOrderType == that.myOrderType && this.myMatcher.equals(that.myMatcher);
    }

    public String toString() {
        return String.format("matcher: %s, sort type: %s", this.myMatcher, this.myOrderType);
    }
}

