/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public final class LanguageSubstitutors
extends LanguageExtension<LanguageSubstitutor> {
    public static final LanguageSubstitutors INSTANCE = new LanguageSubstitutors();
    private static final Logger LOG = Logger.getInstance(LanguageSubstitutors.class);
    private static final Key<Key<Language>> PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY = Key.create((String)"PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY");
    private static final AtomicBoolean REQUESTS_DRAIN_NEEDED = new AtomicBoolean(true);
    private static final ConcurrentMap<VirtualFile, SubstitutionInfo> ourReparsingRequests = ContainerUtil.newConcurrentMap();

    private LanguageSubstitutors() {
        super("com.intellij.lang.substitutor");
    }

    @NotNull
    public Language substituteLanguage(@NotNull Language lang, @NotNull VirtualFile file, @NotNull Project project) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
        }
        for (LanguageSubstitutor substitutor : this.forKey(lang)) {
            Language language = substitutor.getLanguage(file, project);
            if (language == null) continue;
            LanguageSubstitutors.processLanguageSubstitution(file, lang, language, project);
            Language language2 = language;
            if (language2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
            }
            return language2;
        }
        Language language = lang;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
        }
        return language;
    }

    private static void processLanguageSubstitution(@NotNull VirtualFile file, @NotNull Language originalLang, @NotNull Language substitutedLang, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/LanguageSubstitutors", "processLanguageSubstitution"));
        }
        if (originalLang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalLang", "com/intellij/psi/LanguageSubstitutors", "processLanguageSubstitution"));
        }
        if (substitutedLang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutedLang", "com/intellij/psi/LanguageSubstitutors", "processLanguageSubstitution"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/LanguageSubstitutors", "processLanguageSubstitution"));
        }
        if (file instanceof VirtualFileWindow) {
            return;
        }
        Key<Language> projectKey = LanguageSubstitutors.getOrCreateProjectKey(project);
        Language prevSubstitutedLang = (Language)((Object)projectKey.get((UserDataHolder)file));
        Language prevLang = (Language)((Object)ObjectUtils.notNull((Object)((Object)prevSubstitutedLang), (Object)((Object)originalLang)));
        if (!prevLang.is(substitutedLang) && file.replace(projectKey, (Object)prevSubstitutedLang, (Object)substitutedLang)) {
            if (prevSubstitutedLang == null) {
                return;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            LanguageSubstitutors.requestReparsing(file, prevLang, substitutedLang);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Key<Language> getOrCreateProjectKey(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/LanguageSubstitutors", "getOrCreateProjectKey"));
        }
        Key key = (Key)PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY.get((UserDataHolder)project);
        if (key == null) {
            Key<Key<Language>> key2 = PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY;
            synchronized (key2) {
                key = (Key)PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY.get((UserDataHolder)project);
                if (key == null) {
                    key = new Key("Substituted lang key for " + project.getName());
                    PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY.set((UserDataHolder)project, (Object)key);
                }
            }
        }
        Key key3 = key;
        if (key3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/LanguageSubstitutors", "getOrCreateProjectKey"));
        }
        return key3;
    }

    private static void requestReparsing(@NotNull VirtualFile file, @NotNull Language prevLang, @NotNull Language substitutedLang) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/LanguageSubstitutors", "requestReparsing"));
        }
        if (prevLang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prevLang", "com/intellij/psi/LanguageSubstitutors", "requestReparsing"));
        }
        if (substitutedLang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutedLang", "com/intellij/psi/LanguageSubstitutors", "requestReparsing"));
        }
        ourReparsingRequests.put(file, new SubstitutionInfo(prevLang, substitutedLang));
        if (REQUESTS_DRAIN_NEEDED.compareAndSet(true, false)) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    REQUESTS_DRAIN_NEEDED.set(true);
                    ArrayList set = ContainerUtil.newArrayList(ourReparsingRequests.entrySet());
                    ArrayList files = ContainerUtil.newArrayListWithCapacity((int)set.size());
                    int id = 1;
                    for (Map.Entry entry : set) {
                        VirtualFile f = (VirtualFile)entry.getKey();
                        SubstitutionInfo info = (SubstitutionInfo)entry.getValue();
                        ourReparsingRequests.remove(f);
                        if (!f.isValid()) continue;
                        LOG.info("Reparsing " + f.getPath() + " because of language substitution " + info.myPrevLang.getID() + "->" + info.mySubstitutedLang.getID() + ", #" + id++);
                        files.add(f);
                    }
                    if (files.size() > 0) {
                        FileContentUtilCore.reparseFiles(files);
                    }
                }
            }, ModalityState.defaultModalityState());
        }
    }

    public static void cancelReparsing(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/LanguageSubstitutors", "cancelReparsing"));
        }
        ourReparsingRequests.remove(file);
    }

    private static class SubstitutionInfo {
        private final Language myPrevLang;
        private final Language mySubstitutedLang;

        public SubstitutionInfo(@NotNull Language prevLang, @NotNull Language substitutedLang) {
            if (prevLang == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prevLang", "com/intellij/psi/LanguageSubstitutors$SubstitutionInfo", "<init>"));
            }
            if (substitutedLang == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutedLang", "com/intellij/psi/LanguageSubstitutors$SubstitutionInfo", "<init>"));
            }
            this.myPrevLang = prevLang;
            this.mySubstitutedLang = substitutedLang;
        }
    }
}

