/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.text.BlockSupport;
import com.intellij.testFramework.PsiTestCase;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;

public abstract class AbstractReparseTestCase
extends PsiTestCase {
    protected FileType myFileType;
    protected PsiFile myDummyFile;
    private int myInsertOffset;

    protected void setFileType(FileType fileType) {
        this.myFileType = fileType;
    }

    protected void insert(@NonNls String s) throws IncorrectOperationException {
        CommandProcessor.getInstance().executeCommand(this.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
            String oldText = this.myDummyFile.getText();
            String expectedNewText = oldText.substring(0, this.myInsertOffset) + s + oldText.substring(this.myInsertOffset);
            try {
                this.doReparseAndCheck(s, expectedNewText, 0);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            this.myInsertOffset += s.length();
        }), "asd", null);
    }

    protected void moveEditPointLeft(int count) {
        this.myInsertOffset -= count;
    }

    protected void moveEditPointRight(int count) {
        this.myInsertOffset += count;
    }

    protected void setEditPoint(int pos) {
        this.myInsertOffset = pos;
    }

    protected void remove(int count) throws IncorrectOperationException {
        String oldText = this.myDummyFile.getText();
        String expectedNewText = oldText.substring(0, this.myInsertOffset - count) + oldText.substring(this.myInsertOffset);
        this.doReparseAndCheck("", expectedNewText, count);
        this.myInsertOffset -= count;
    }

    private void doReparseAndCheck(String s, String expectedNewText, int length) throws IncorrectOperationException {
        this.doReparse(s, length);
        String foundStructure = DebugUtil.treeToString((ASTNode)SourceTreeToPsiMap.psiElementToTree((PsiElement)this.myDummyFile), (boolean)false);
        PsiFile psiFile = this.createDummyFile(this.getName() + "." + this.myFileType.getDefaultExtension(), expectedNewText);
        String expectedStructure = DebugUtil.treeToString((ASTNode)SourceTreeToPsiMap.psiElementToTree((PsiElement)psiFile), (boolean)false);
        if (!expectedStructure.equals(foundStructure)) {
            System.out.println("expected: ");
            System.out.println(expectedStructure);
            System.out.println("found: ");
            System.out.println(foundStructure);
            AbstractReparseTestCase.assertEquals((String)expectedStructure, (String)foundStructure);
        }
        AbstractReparseTestCase.assertEquals((String)"Reparse tree should be equal to the document", (String)expectedNewText, (String)this.myDummyFile.getText());
    }

    protected void doReparse(String s, int length) {
        CommandProcessor.getInstance().executeCommand(this.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
            BlockSupport blockSupport = ServiceManager.getService(this.myProject, BlockSupport.class);
            try {
                blockSupport.reparseRange(this.myDummyFile, this.myInsertOffset - length, this.myInsertOffset, (CharSequence)s);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }), "asd", null);
    }

    protected void prepareFile(@NonNls String prefix, @NonNls String suffix) throws IncorrectOperationException {
        this.myDummyFile = this.createDummyFile(this.getName() + "." + this.myFileType.getDefaultExtension(), prefix + suffix);
        this.myInsertOffset = prefix.length();
    }
}

