/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.util.Processor;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalFileSystem
extends NewVirtualFileSystem {
    @NonNls
    public static final String PROTOCOL = "file";
    @NonNls
    public static final String PROTOCOL_PREFIX = "file://";

    public static LocalFileSystem getInstance() {
        return LocalFileSystemHolder.ourInstance;
    }

    @Nullable
    public abstract VirtualFile findFileByIoFile(@NotNull File var1);

    @Nullable
    public abstract VirtualFile refreshAndFindFileByIoFile(@NotNull File var1);

    public abstract void refreshIoFiles(@NotNull Iterable<File> var1);

    public abstract void refreshIoFiles(@NotNull Iterable<File> var1, boolean var2, boolean var3, @Nullable Runnable var4);

    public abstract void refreshFiles(@NotNull Iterable<VirtualFile> var1);

    public abstract void refreshFiles(@NotNull Iterable<VirtualFile> var1, boolean var2, boolean var3, @Nullable Runnable var4);

    @Nullable
    public WatchRequest addRootToWatch(@NotNull String rootPath, boolean watchRecursively) {
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "com/intellij/openapi/vfs/LocalFileSystem", "addRootToWatch"));
        }
        Set<WatchRequest> result = this.addRootsToWatch(Collections.singleton(rootPath), watchRecursively);
        return result.size() == 1 ? result.iterator().next() : null;
    }

    @NotNull
    public Set<WatchRequest> addRootsToWatch(@NotNull Collection<String> rootPaths, boolean watchRecursively) {
        if (rootPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPaths", "com/intellij/openapi/vfs/LocalFileSystem", "addRootsToWatch"));
        }
        if (rootPaths.isEmpty()) {
            Set<WatchRequest> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/LocalFileSystem", "addRootsToWatch"));
            }
            return set;
        }
        if (watchRecursively) {
            Set<WatchRequest> set = this.replaceWatchedRoots(Collections.emptySet(), rootPaths, null);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/LocalFileSystem", "addRootsToWatch"));
            }
            return set;
        }
        Set<WatchRequest> set = this.replaceWatchedRoots(Collections.emptySet(), null, rootPaths);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/LocalFileSystem", "addRootsToWatch"));
        }
        return set;
    }

    public void removeWatchedRoot(@Nullable WatchRequest watchRequest) {
        if (watchRequest != null) {
            this.removeWatchedRoots(Collections.singleton(watchRequest));
        }
    }

    public void removeWatchedRoots(@NotNull Collection<WatchRequest> watchRequests) {
        if (watchRequests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "watchRequests", "com/intellij/openapi/vfs/LocalFileSystem", "removeWatchedRoots"));
        }
        if (!watchRequests.isEmpty()) {
            this.replaceWatchedRoots(watchRequests, null, null);
        }
    }

    @Nullable
    public WatchRequest replaceWatchedRoot(@Nullable WatchRequest watchRequest, @NotNull String rootPath, boolean watchRecursively) {
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "com/intellij/openapi/vfs/LocalFileSystem", "replaceWatchedRoot"));
        }
        Set<WatchRequest> requests = watchRequest != null ? Collections.singleton(watchRequest) : Collections.emptySet();
        Set<String> roots = Collections.singleton(rootPath);
        Set<WatchRequest> result = watchRecursively ? this.replaceWatchedRoots(requests, roots, null) : this.replaceWatchedRoots(requests, null, roots);
        return result.size() == 1 ? result.iterator().next() : null;
    }

    @NotNull
    public abstract Set<WatchRequest> replaceWatchedRoots(@NotNull Collection<WatchRequest> var1, @Nullable Collection<String> var2, @Nullable Collection<String> var3);

    public abstract void registerAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler var1);

    public abstract void unregisterAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler var1);

    public abstract boolean processCachedFilesInSubtree(@NotNull VirtualFile var1, @NotNull Processor<VirtualFile> var2);

    public static interface WatchRequest {
        @NotNull
        public String getRootPath();

        public boolean isToWatchRecursively();
    }

    private static class LocalFileSystemHolder {
        private static final LocalFileSystem ourInstance = (LocalFileSystem)VirtualFileManager.getInstance().getFileSystem("file");

        private LocalFileSystemHolder() {
        }
    }
}

