/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BusyObject {
    @NotNull
    public ActionCallback getReady(@NotNull Object var1);

    public static abstract class Impl
    implements BusyObject {
        private final Map<Object, ActionCallback> myReadyCallbacks = new WeakHashMap<Object, ActionCallback>();

        public abstract boolean isReady();

        public final void onReady() {
            this.onReady(null);
        }

        public final void onReady(@Nullable Object readyRequestor) {
            if (!this.isReady()) {
                return;
            }
            if (readyRequestor != null) {
                Pair<ActionCallback, List<ActionCallback>> callbacks = this.getReadyCallbacks(readyRequestor);
                ((ActionCallback)callbacks.getFirst()).setDone();
                for (ActionCallback each : (List)callbacks.getSecond()) {
                    each.setRejected();
                }
            } else {
                ActionCallback[] callbacks;
                for (ActionCallback each : callbacks = this.getReadyCallbacks()) {
                    each.setDone();
                }
            }
            this.onReadyWasSent();
        }

        protected void onReadyWasSent() {
        }

        @Override
        @NotNull
        public final ActionCallback getReady(@NotNull Object requestor) {
            if (requestor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/util/BusyObject$Impl", "getReady"));
            }
            if (this.isReady()) {
                ActionCallback actionCallback = ActionCallback.DONE;
                if (actionCallback == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/BusyObject$Impl", "getReady"));
                }
                return actionCallback;
            }
            ActionCallback actionCallback = this.addReadyCallback(requestor);
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/BusyObject$Impl", "getReady"));
            }
            return actionCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        private ActionCallback addReadyCallback(Object requestor) {
            Map<Object, ActionCallback> map = this.myReadyCallbacks;
            // MONITORENTER : map
            ActionCallback cb = this.myReadyCallbacks.get(requestor);
            if (cb == null) {
                cb = new ActionCallback();
                this.myReadyCallbacks.put(requestor, cb);
            }
            ActionCallback actionCallback = cb;
            // MONITOREXIT : map
            if (actionCallback != null) return actionCallback;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/BusyObject$Impl", "addReadyCallback"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        private ActionCallback[] getReadyCallbacks() {
            Map<Object, ActionCallback> map = this.myReadyCallbacks;
            // MONITORENTER : map
            ActionCallback[] result = this.myReadyCallbacks.values().toArray(new ActionCallback[this.myReadyCallbacks.size()]);
            this.myReadyCallbacks.clear();
            // MONITOREXIT : map
            if (result != null) return result;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/BusyObject$Impl", "getReadyCallbacks"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        private Pair<ActionCallback, List<ActionCallback>> getReadyCallbacks(Object readyRequestor) {
            Map<Object, ActionCallback> map = this.myReadyCallbacks;
            // MONITORENTER : map
            ActionCallback done2 = this.myReadyCallbacks.get(readyRequestor);
            if (done2 == null) {
                done2 = new ActionCallback();
            }
            this.myReadyCallbacks.remove(readyRequestor);
            ArrayList<ActionCallback> rejected2 = new ArrayList<ActionCallback>();
            rejected2.addAll(this.myReadyCallbacks.values());
            this.myReadyCallbacks.clear();
            Pair pair = new Pair((Object)done2, rejected2);
            // MONITOREXIT : map
            if (pair != null) return pair;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/BusyObject$Impl", "getReadyCallbacks"));
        }

        public static class Simple
        extends Impl {
            private final AtomicInteger myBusyCount = new AtomicInteger();

            @Override
            public boolean isReady() {
                return this.myBusyCount.get() == 0;
            }

            @NotNull
            public ActionCallback execute(@NotNull ActiveRunnable runnable) {
                if (runnable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/util/BusyObject$Impl$Simple", "execute"));
                }
                this.myBusyCount.addAndGet(1);
                ActionCallback cb = runnable.run();
                cb.doWhenProcessed(new Runnable(){

                    @Override
                    public void run() {
                        Simple.this.myBusyCount.addAndGet(-1);
                        if (Simple.this.isReady()) {
                            Simple.this.onReady();
                        }
                    }
                });
                ActionCallback actionCallback = cb;
                if (actionCallback == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/BusyObject$Impl$Simple", "execute"));
                }
                return actionCallback;
            }
        }
    }
}

