/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.layout;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.DataProvider;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.EdgeList;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.base.NodeList;
import com.intellij.openapi.graph.geom.OrientedRectangle;
import com.intellij.openapi.graph.geom.YDimension;
import com.intellij.openapi.graph.geom.YPoint;
import com.intellij.openapi.graph.geom.YPointPath;
import com.intellij.openapi.graph.layout.EdgeLabelModel;
import com.intellij.openapi.graph.layout.EdgeLayout;
import com.intellij.openapi.graph.layout.GraphLayout;
import com.intellij.openapi.graph.layout.LayoutGraph;
import com.intellij.openapi.graph.layout.NodeLabelModel;
import com.intellij.openapi.graph.layout.NodeLayout;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;

public interface LayoutTool {
    public static final int LEADING = GraphManager.getGraphManager()._LayoutTool_LEADING();
    public static final int TRAILING = GraphManager.getGraphManager()._LayoutTool_TRAILING();
    public static final int JUSTIFIED = GraphManager.getGraphManager()._LayoutTool_JUSTIFIED();
    public static final int CENTER = GraphManager.getGraphManager()._LayoutTool_CENTER();
    public static final byte FLOW_UP = GraphManager.getGraphManager()._LayoutTool_FLOW_UP();
    public static final byte FLOW_DOWN = GraphManager.getGraphManager()._LayoutTool_FLOW_DOWN();
    public static final byte FLOW_LEFT = GraphManager.getGraphManager()._LayoutTool_FLOW_LEFT();
    public static final byte FLOW_RIGHT = GraphManager.getGraphManager()._LayoutTool_FLOW_RIGHT();
    public static final byte FLOW_NONE = GraphManager.getGraphManager()._LayoutTool_FLOW_NONE();

    public static class Statics {
        public static byte determineEdgeFlowDirection(LayoutGraph graph, DataProvider considerEdges) {
            return GraphManager.getGraphManager()._LayoutTool_determineEdgeFlowDirection(graph, considerEdges);
        }

        public static boolean isUsingOrthogonalEdgeRoutes(LayoutGraph graph, DataProvider considerEdges) {
            return GraphManager.getGraphManager()._LayoutTool_isUsingOrthogonalEdgeRoutes(graph, considerEdges);
        }

        public static boolean isUsingOctilinearEdgeRoutes(LayoutGraph graph, DataProvider considerEdges) {
            return GraphManager.getGraphManager()._LayoutTool_isUsingOctilinearEdgeRoutes(graph, considerEdges);
        }

        public static double getNodeDistance(LayoutGraph graph, Node s, Node t) {
            return GraphManager.getGraphManager()._LayoutTool_getNodeDistance(graph, s, t);
        }

        public static double getPathLength(LayoutGraph graph, Edge e) {
            return GraphManager.getGraphManager()._LayoutTool_getPathLength(graph, e);
        }

        public static void reverseEdgeLayout(EdgeLayout el) {
            GraphManager.getGraphManager()._LayoutTool_reverseEdgeLayout(el);
        }

        public static void resetPaths(LayoutGraph gd) {
            GraphManager.getGraphManager()._LayoutTool_resetPaths(gd);
        }

        public static void resetPaths(LayoutGraph gd, boolean resetPorts) {
            GraphManager.getGraphManager()._LayoutTool_resetPaths(gd, resetPorts);
        }

        public static void resetPath(LayoutGraph gd, Edge edge) {
            GraphManager.getGraphManager()._LayoutTool_resetPath(gd, edge);
        }

        public static void resetPath(LayoutGraph gd, Edge edge, boolean resetPorts) {
            GraphManager.getGraphManager()._LayoutTool_resetPath(gd, edge, resetPorts);
        }

        public static void removeDuplicateBends(LayoutGraph gd) {
            GraphManager.getGraphManager()._LayoutTool_removeDuplicateBends(gd);
        }

        public static void removeDuplicateBends(LayoutGraph gd, Edge edge) {
            GraphManager.getGraphManager()._LayoutTool_removeDuplicateBends(gd, edge);
        }

        public static void moveEdge(LayoutGraph g, Edge edge, double dx, double dy) {
            GraphManager.getGraphManager()._LayoutTool_moveEdge(g, edge, dx, dy);
        }

        public static void moveEdges(LayoutGraph g, EdgeCursor edges, double dx, double dy) {
            GraphManager.getGraphManager()._LayoutTool_moveEdges(g, edges, dx, dy);
        }

        public static void moveNode(LayoutGraph g, Node node, double dx, double dy) {
            GraphManager.getGraphManager()._LayoutTool_moveNode(g, node, dx, dy);
        }

        public static void moveNodes(LayoutGraph g, NodeCursor nodes, double dx, double dy) {
            GraphManager.getGraphManager()._LayoutTool_moveNodes(g, nodes, dx, dy);
        }

        public static void moveSubgraph(LayoutGraph g, EdgeCursor edges, double dx, double dy) {
            GraphManager.getGraphManager()._LayoutTool_moveSubgraph(g, edges, dx, dy);
        }

        public static void moveSubgraph(LayoutGraph g, NodeCursor nodes, double dx, double dy) {
            GraphManager.getGraphManager()._LayoutTool_moveSubgraph(g, nodes, dx, dy);
        }

        public static Rectangle2D getBoundingBox(LayoutGraph graph, NodeCursor nc, EdgeCursor ec) {
            return GraphManager.getGraphManager()._LayoutTool_getBoundingBox(graph, nc, ec);
        }

        public static Rectangle2D getBoundingBox(LayoutGraph graph, Node n) {
            return GraphManager.getGraphManager()._LayoutTool_getBoundingBox(graph, n);
        }

        public static Rectangle2D getBoundingBox(LayoutGraph graph, NodeCursor nc) {
            return GraphManager.getGraphManager()._LayoutTool_getBoundingBox(graph, nc);
        }

        public static Rectangle2D getBoundingBox(LayoutGraph graph, Edge e) {
            return GraphManager.getGraphManager()._LayoutTool_getBoundingBox(graph, e);
        }

        public static Rectangle2D getBoundingBox(LayoutGraph graph, EdgeCursor ec) {
            return GraphManager.getGraphManager()._LayoutTool_getBoundingBox(graph, ec);
        }

        public static Rectangle2D getBoundingBox(LayoutGraph graph, NodeCursor nc, EdgeCursor ec, boolean includeLabels) {
            return GraphManager.getGraphManager()._LayoutTool_getBoundingBox(graph, nc, ec, includeLabels);
        }

        public static YPoint getLabelPlacement(NodeLabelModel model, YDimension labelSize, NodeLayout nodeLayout, Object param) {
            return GraphManager.getGraphManager()._LayoutTool_getLabelPlacement(model, labelSize, nodeLayout, param);
        }

        public static YPoint getLabelPlacement(EdgeLabelModel model, YDimension labelSize, EdgeLayout edgeLayout, NodeLayout sourceLayout, NodeLayout targetLayout, Object param) {
            return GraphManager.getGraphManager()._LayoutTool_getLabelPlacement(model, labelSize, edgeLayout, sourceLayout, targetLayout, param);
        }

        public static void resetPorts(LayoutGraph gd) {
            GraphManager.getGraphManager()._LayoutTool_resetPorts(gd);
        }

        public static YPointPath getEdgeClippedOnBB(EdgeLayout edge, NodeLayout sourceNode, NodeLayout targetNode) {
            return GraphManager.getGraphManager()._LayoutTool_getEdgeClippedOnBB(edge, sourceNode, targetNode);
        }

        public static YPointPath getEdgeClippedOnBB(LayoutGraph gd, Edge edge) {
            return GraphManager.getGraphManager()._LayoutTool_getEdgeClippedOnBB(gd, edge);
        }

        public static YPointPath getEdgeClippedOnBB(EdgeLayout edge, NodeLayout sourceNode, NodeLayout targetNode, double inset) {
            return GraphManager.getGraphManager()._LayoutTool_getEdgeClippedOnBB(edge, sourceNode, targetNode, inset);
        }

        public static boolean isEdgeOutsideNodes(LayoutGraph gd, Edge edge) {
            return GraphManager.getGraphManager()._LayoutTool_isEdgeOutsideNodes(gd, edge);
        }

        public static boolean isEdgeOutsideNodes(EdgeLayout edge, NodeLayout sourceNode, NodeLayout targetNode, double inset) {
            return GraphManager.getGraphManager()._LayoutTool_isEdgeOutsideNodes(edge, sourceNode, targetNode, inset);
        }

        public static void clipEdgesOnBB(LayoutGraph gd) {
            GraphManager.getGraphManager()._LayoutTool_clipEdgesOnBB(gd);
        }

        public static void clipEdgeOnBB(LayoutGraph gd, Edge e) {
            GraphManager.getGraphManager()._LayoutTool_clipEdgeOnBB(gd, e);
        }

        public static String edgeLayoutString(LayoutGraph gd, Edge edge) {
            return GraphManager.getGraphManager()._LayoutTool_edgeLayoutString(gd, edge);
        }

        public static void roundNodeLayout(LayoutGraph gd, Node node) {
            GraphManager.getGraphManager()._LayoutTool_roundNodeLayout(gd, node);
        }

        public static void roundEdgeLayout(LayoutGraph gd, Edge edge) {
            GraphManager.getGraphManager()._LayoutTool_roundEdgeLayout(gd, edge);
        }

        public static void roundLayout(LayoutGraph gd) {
            GraphManager.getGraphManager()._LayoutTool_roundLayout(gd);
        }

        public static void routeEdgesParallel(LayoutGraph gd, Edge e1, Edge e2, double lineDistance) {
            GraphManager.getGraphManager()._LayoutTool_routeEdgesParallel(gd, e1, e2, lineDistance);
        }

        public static void routeEdgesParallel(LayoutGraph gd, Edge e1, Edge e2, double lineDistance, boolean joinEnds, double absJoinDist, double relJoinDist) {
            GraphManager.getGraphManager()._LayoutTool_routeEdgesParallel(gd, e1, e2, lineDistance, joinEnds, absJoinDist, relJoinDist);
        }

        public static void routeEdgesParallel(LayoutGraph gd, Edge e1, EdgeList list, double lineDistance) {
            GraphManager.getGraphManager()._LayoutTool_routeEdgesParallel(gd, e1, list, lineDistance);
        }

        public static void routeEdgesParallel(LayoutGraph gd, Edge e1, EdgeList list, double lineDistance, boolean adjustE1, boolean joinEnds, double absJoinDist, double relJoinDist) {
            GraphManager.getGraphManager()._LayoutTool_routeEdgesParallel(gd, e1, list, lineDistance, adjustE1, joinEnds, absJoinDist, relJoinDist);
        }

        public static void routeSelfLoop(LayoutGraph gd, Edge e) {
            GraphManager.getGraphManager()._LayoutTool_routeSelfLoop(gd, e);
        }

        public static void assignReverseLayout(LayoutGraph graph, Edge e1, Edge e2) {
            GraphManager.getGraphManager()._LayoutTool_assignReverseLayout(graph, e1, e2);
        }

        public static String getNodePositions(LayoutGraph gd) {
            return GraphManager.getGraphManager()._LayoutTool_getNodePositions(gd);
        }

        public static void initDiagram(LayoutGraph gd) {
            GraphManager.getGraphManager()._LayoutTool_initDiagram(gd);
        }

        public static int arrangeRectangleRows(Rectangle2D[] rects, Rectangle2D finalRect, double viewRatio) {
            return GraphManager.getGraphManager()._LayoutTool_arrangeRectangleRows(rects, finalRect, viewRatio);
        }

        public static Dimension arrangeRectangleGrid(Rectangle2D[] rects, Rectangle2D finalRect, double viewRatio) {
            return GraphManager.getGraphManager()._LayoutTool_arrangeRectangleGrid(rects, finalRect, viewRatio);
        }

        public static int arrangeRectangleRows(Rectangle2D[] rects, Rectangle2D finalRect, double viewRatio, int alignment) {
            return GraphManager.getGraphManager()._LayoutTool_arrangeRectangleRows(rects, finalRect, viewRatio, alignment);
        }

        public static boolean pathIntersectsRect(LayoutGraph graph, Edge e, Rectangle2D rect) {
            return GraphManager.getGraphManager()._LayoutTool_pathIntersectsRect(graph, e, rect);
        }

        public static void applyGraphLayout(LayoutGraph graph, GraphLayout gl) {
            GraphManager.getGraphManager()._LayoutTool_applyGraphLayout(graph, gl);
        }

        public static void alignNodeLayouts(LayoutGraph g, NodeList nodes, Node referenceNode, boolean vertical, byte mode) {
            GraphManager.getGraphManager()._LayoutTool_alignNodeLayouts(g, nodes, referenceNode, vertical, mode);
        }

        public static boolean autoFlipBox(OrientedRectangle rect) {
            return GraphManager.getGraphManager()._LayoutTool_autoFlipBox(rect);
        }
    }
}

