/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.renderer;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.renderer.AbstractColoredNodeCellRenderer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class BasicGraphNodeRenderer<N, E>
extends AbstractColoredNodeCellRenderer {
    private final GraphBuilder<N, E> myBuilder;

    public BasicGraphNodeRenderer(GraphBuilder<N, E> builder, ModificationTracker modificationTracker) {
        super(modificationTracker);
        this.myBuilder = builder;
    }

    @Override
    public void tuneNode(NodeRealizer nodeRealizer, JPanel wrapper) {
        wrapper.removeAll();
        wrapper.setLayout(new BorderLayout());
        Node node = nodeRealizer.getNode();
        N object = this.myBuilder.getNodeObject(node);
        if (object == null) {
            return;
        }
        wrapper.add((Component)this.getIconLabel(object), "West");
        wrapper.add((Component)this.getLabelPanel(nodeRealizer), "Center");
    }

    protected JComponent getLabelPanel(NodeRealizer nodeRealizer) {
        Node node = nodeRealizer.getNode();
        N object = this.myBuilder.getNodeObject(node);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createLineBorder((Color)JBColor.white, 2));
        jPanel.setBackground(this.getBackground(object));
        jPanel.setLayout(new BorderLayout());
        String text = this.getNodeName(object);
        JComponent comp = this.getPresenationComponent(text);
        comp.setForeground(this.getForeground(object));
        comp.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        jPanel.add((Component)comp, "West");
        return jPanel;
    }

    protected JComponent getPresenationComponent(String text) {
        return new JLabel(text);
    }

    protected Color getForeground(N node) {
        return JBColor.foreground();
    }

    protected Color getBackground(N node) {
        return JBColor.background();
    }

    protected Icon getIcon(N node) {
        return AllIcons.FileTypes.Unknown;
    }

    protected JComponent getIconLabel(N node) {
        JLabel jLabel = new JLabel(this.getIcon(node));
        jLabel.setBorder(JBUI.Borders.empty((int)5));
        return jLabel;
    }

    protected String getNodeName(N node) {
        return "";
    }

    public GraphBuilder<N, E> getBuilder() {
        return this.myBuilder;
    }
}

