/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.layout;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.builder.actions.layout.AbstractLayoutAction;
import com.intellij.openapi.graph.settings.GraphSettingsProvider;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;

public class ApplyCurrentLayoutAction
extends AbstractGraphAction<Graph2D> {
    private static final String NAME = ActionsBundle.message("action.Graph.layout.apply.current", new Object[0]);

    public ApplyCurrentLayoutAction() {
        super(NAME, AllIcons.Graph.Layout);
    }

    public ApplyCurrentLayoutAction(Graph2D graph) {
        super(graph, NAME, AllIcons.Graph.Layout);
    }

    @Override
    public void actionPerformed(AnActionEvent e, Graph2D graph) {
        Graph2DView view = AbstractGraphAction.getGraph2DView(graph);
        Project project = ApplyCurrentLayoutAction.getProject(e);
        if (project != null) {
            AbstractLayoutAction.doLayout(view, GraphSettingsProvider.getInstance(project).getSettings(graph).getCurrentLayouter(), project);
        }
    }

    @Override
    public void update(AnActionEvent e, Graph2D graph) {
        Project project = ApplyCurrentLayoutAction.getProject(e);
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(project != null && graph != null && graph.getNodeArray().length > 0 && ApplyCurrentLayoutAction.canLayout(graph, project));
    }

    private static boolean canLayout(Graph2D graph, Project project) {
        try {
            return GraphSettingsProvider.getInstance(project).getSettings(graph).getCurrentLayouter().canLayout(graph);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

