/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGraphAction<T extends Graph2D>
extends AnAction {
    private final T myGraph;

    protected AbstractGraphAction() {
        this(null, null);
    }

    protected AbstractGraphAction(String name, Icon icon) {
        this(null, name, icon);
    }

    protected AbstractGraphAction(T graph) {
        this(graph, null, null);
    }

    protected AbstractGraphAction(T graph, String name, Icon icon) {
        super(name, name, icon);
        this.myGraph = graph;
    }

    @Override
    public final void update(AnActionEvent e) {
        T graph = this.getGraph(e);
        if (graph != null) {
            this.update(e, graph);
        } else {
            e.getPresentation().setEnabled(false);
        }
    }

    @Nullable
    protected T getGraph(AnActionEvent e) {
        if (this.myGraph != null) {
            return this.myGraph;
        }
        return (T)((Graph2D)e.getDataContext().getData(GraphViewUtil.GRAPH_KEY));
    }

    @Nullable
    protected GraphBuilder getBuilder(AnActionEvent e) {
        return (GraphBuilder)((Object)e.getDataContext().getData(GraphBuilder.GRAPH_BUILDER_KEY));
    }

    @Nullable
    public static Project getProject(AnActionEvent e) {
        return e.getProject();
    }

    public static Graph2DView getGraph2DView(@NotNull Graph2D graph2D) {
        if (graph2D == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph2D", "com/intellij/openapi/graph/builder/actions/AbstractGraphAction", "getGraph2DView"));
        }
        return (Graph2DView)graph2D.getCurrentView();
    }

    @Override
    public final void actionPerformed(AnActionEvent e) {
        T graph = this.getGraph(e);
        if (graph != null) {
            this.actionPerformed(e, graph);
            graph.updateViews();
        }
    }

    protected abstract void actionPerformed(AnActionEvent var1, T var2);

    protected void update(AnActionEvent e, T graph) {
    }
}

