/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder;

import com.intellij.openapi.graph.builder.GraphDataModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class CachedGraphDataModel<N, E>
extends GraphDataModel<N, E> {
    private boolean myDirty = true;
    protected final Set<N> myNodes = new HashSet<N>();
    protected final Map<E, EdgeInfo<N>> myEdges = new HashMap<E, EdgeInfo<N>>();

    @Override
    @NotNull
    public Collection<N> getNodes() {
        this.checkUpdate();
        Set<N> set = this.myNodes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/CachedGraphDataModel", "getNodes"));
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<E> getEdges() {
        this.checkUpdate();
        Set<E> set = this.myEdges.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/CachedGraphDataModel", "getEdges"));
        }
        return set;
    }

    @Override
    public N getSourceNode(E e) {
        EdgeInfo<N> info = this.myEdges.get(e);
        return info.source;
    }

    @Override
    public N getTargetNode(E e) {
        EdgeInfo<N> info = this.myEdges.get(e);
        return info.target;
    }

    @Override
    public E createEdge(@NotNull N from, @NotNull N to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/openapi/graph/builder/CachedGraphDataModel", "createEdge"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/openapi/graph/builder/CachedGraphDataModel", "createEdge"));
        }
        return null;
    }

    public void dispose() {
    }

    protected void createNode(N node) {
        this.myNodes.add(node);
    }

    protected void createEdge(E edge, N source, N target) {
        this.myEdges.put(edge, new EdgeInfo<N>(source, target));
    }

    protected final synchronized void checkUpdate() {
        if (this.myDirty) {
            this.buildGraph();
            this.myDirty = false;
        }
    }

    protected abstract void buildGraph();

    protected void clear() {
        this.myNodes.clear();
        this.myEdges.clear();
    }

    public final synchronized void setDirty() {
        this.myDirty = true;
    }

    protected static class EdgeInfo<N> {
        final N source;
        final N target;

        EdgeInfo(N source, N target) {
            this.source = source;
            this.target = target;
        }
    }
}

