/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public interface FileEditorProvider {
    public static final ExtensionPointName<FileEditorProvider> EP_FILE_EDITOR_PROVIDER = new ExtensionPointName("com.intellij.fileEditorProvider");
    public static final Key<FileEditorProvider> KEY = Key.create((String)"com.intellij.fileEditorProvider");

    public boolean accept(@NotNull Project var1, @NotNull VirtualFile var2);

    @NotNull
    public FileEditor createEditor(@NotNull Project var1, @NotNull VirtualFile var2);

    default public void disposeEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/FileEditorProvider", "disposeEditor"));
        }
        Disposer.dispose((Disposable)editor);
    }

    @NotNull
    default public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/openapi/fileEditor/FileEditorProvider", "readState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/FileEditorProvider", "readState"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/FileEditorProvider", "readState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/FileEditorProvider", "readState"));
        }
        return fileEditorState;
    }

    default public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/fileEditor/FileEditorProvider", "writeState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/FileEditorProvider", "writeState"));
        }
        if (targetElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElement", "com/intellij/openapi/fileEditor/FileEditorProvider", "writeState"));
        }
    }

    @NotNull
    @NonNls
    public String getEditorTypeId();

    @NotNull
    public FileEditorPolicy getPolicy();
}

