/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.TObjectIntHashMap;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontPreferences {
    @NonNls
    @NotNull
    public static final String DEFAULT_FONT_NAME = FontPreferences.getDefaultFontName();
    public static final int DEFAULT_FONT_SIZE = FontSize.SMALL.getSize();
    @NotNull
    private final TObjectIntHashMap<String> myFontSizes = new TObjectIntHashMap();
    @NotNull
    private final List<String> myEffectiveFontFamilies = ContainerUtilRt.newArrayList();
    @NotNull
    private final List<String> myRealFontFamilies = ContainerUtilRt.newArrayList();
    private boolean myUseLigatures;
    @Nullable
    private Runnable myChangeListener;
    private int myTemplateFontSize = DEFAULT_FONT_SIZE;

    public void setChangeListener(@Nullable Runnable changeListener) {
        this.myChangeListener = changeListener;
    }

    @Nullable
    public Runnable getChangeListener() {
        return this.myChangeListener;
    }

    public void clear() {
        this.myEffectiveFontFamilies.clear();
        this.myRealFontFamilies.clear();
        this.myFontSizes.clear();
        if (this.myChangeListener != null) {
            this.myChangeListener.run();
        }
    }

    public void clearFonts() {
        this.myEffectiveFontFamilies.clear();
        this.myRealFontFamilies.clear();
        if (this.myChangeListener != null) {
            this.myChangeListener.run();
        }
    }

    public boolean hasSize(@NotNull String fontName) {
        if (fontName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontName", "com/intellij/openapi/editor/colors/FontPreferences", "hasSize"));
        }
        return this.myFontSizes.containsKey((Object)fontName);
    }

    public int getSize(@NotNull String fontFamily) {
        if (fontFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontFamily", "com/intellij/openapi/editor/colors/FontPreferences", "getSize"));
        }
        int result = this.myFontSizes.get((Object)fontFamily);
        if (result <= 0) {
            result = this.myTemplateFontSize;
        }
        return result > 0 ? result : DEFAULT_FONT_SIZE;
    }

    public void setSize(@NotNull String fontFamily, int size) {
        if (fontFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontFamily", "com/intellij/openapi/editor/colors/FontPreferences", "setSize"));
        }
        this.myFontSizes.put((Object)fontFamily, size);
        this.myTemplateFontSize = size;
        if (this.myChangeListener != null) {
            this.myChangeListener.run();
        }
    }

    @NotNull
    public List<String> getEffectiveFontFamilies() {
        List<String> list = this.myEffectiveFontFamilies;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/FontPreferences", "getEffectiveFontFamilies"));
        }
        return list;
    }

    @NotNull
    public List<String> getRealFontFamilies() {
        List<String> list = this.myRealFontFamilies;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/FontPreferences", "getRealFontFamilies"));
        }
        return list;
    }

    public void register(@NotNull String fontFamily, int size) {
        String effectiveFontFamily;
        if (fontFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontFamily", "com/intellij/openapi/editor/colors/FontPreferences", "register"));
        }
        String fallbackFontFamily = FontPreferences.getFallbackName(fontFamily, size, null);
        if (!this.myRealFontFamilies.contains(fontFamily)) {
            this.myRealFontFamilies.add(fontFamily);
        }
        String string = effectiveFontFamily = fallbackFontFamily == null ? fontFamily : fallbackFontFamily;
        if (!this.myEffectiveFontFamilies.contains(effectiveFontFamily)) {
            this.myEffectiveFontFamilies.add(effectiveFontFamily);
        }
        this.setSize(fontFamily, size);
    }

    @NotNull
    public String getFontFamily() {
        String string = this.myEffectiveFontFamilies.isEmpty() ? DEFAULT_FONT_NAME : this.myEffectiveFontFamilies.get(0);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/FontPreferences", "getFontFamily"));
        }
        return string;
    }

    public void addFontFamily(@NotNull String fontFamily) {
        String effectiveFontFamily;
        if (fontFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontFamily", "com/intellij/openapi/editor/colors/FontPreferences", "addFontFamily"));
        }
        String fallbackFontFamily = FontPreferences.getFallbackName(fontFamily, DEFAULT_FONT_SIZE, null);
        if (!this.myRealFontFamilies.contains(fontFamily)) {
            this.myRealFontFamilies.add(fontFamily);
        }
        String string = effectiveFontFamily = fallbackFontFamily == null ? fontFamily : fallbackFontFamily;
        if (!this.myEffectiveFontFamilies.contains(effectiveFontFamily)) {
            this.myEffectiveFontFamilies.add(effectiveFontFamily);
        }
        if (this.myChangeListener != null) {
            this.myChangeListener.run();
        }
    }

    public void copyTo(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/FontPreferences", "copyTo"));
        }
        preferences.myEffectiveFontFamilies.clear();
        preferences.myEffectiveFontFamilies.addAll(this.myEffectiveFontFamilies);
        preferences.myRealFontFamilies.clear();
        preferences.myRealFontFamilies.addAll(this.myRealFontFamilies);
        preferences.myFontSizes.clear();
        preferences.myTemplateFontSize = this.myTemplateFontSize;
        for (String fontFamily : this.myRealFontFamilies) {
            if (!this.myFontSizes.containsKey((Object)fontFamily)) continue;
            preferences.myFontSizes.put((Object)fontFamily, this.myFontSizes.get((Object)fontFamily));
        }
        preferences.myUseLigatures = this.myUseLigatures;
    }

    public int hashCode() {
        return this.myRealFontFamilies.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontPreferences that = (FontPreferences)o;
        if (!this.myRealFontFamilies.equals(that.myRealFontFamilies)) {
            return false;
        }
        for (String fontFamily : this.myRealFontFamilies) {
            if (this.myFontSizes.get((Object)fontFamily) == that.myFontSizes.get((Object)fontFamily)) continue;
            return false;
        }
        return this.myUseLigatures == that.myUseLigatures;
    }

    @NotNull
    private static String getDefaultFontName() {
        if (SystemInfo.isMacOSSnowLeopard) {
            if ("Menlo" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/FontPreferences", "getDefaultFontName"));
            }
            return "Menlo";
        }
        if (SystemInfo.isXWindow && !GraphicsEnvironment.isHeadless()) {
            for (Font font : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
                if (!"DejaVu Sans Mono".equals(font.getName())) continue;
                String string = font.getFontName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/FontPreferences", "getDefaultFontName"));
                }
                return string;
            }
        }
        if ("Monospaced" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/FontPreferences", "getDefaultFontName"));
        }
        return "Monospaced";
    }

    @Nullable
    public static String getFallbackName(@NotNull String fontName, int fontSize, @Nullable EditorColorsScheme fallbackScheme) {
        if (fontName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontName", "com/intellij/openapi/editor/colors/FontPreferences", "getFallbackName"));
        }
        Font plainFont = new Font(fontName, 0, fontSize);
        if (plainFont.getFamily().equals("Dialog") && !"Dialog".equals(fontName) && !fontName.startsWith("Dialog.")) {
            return fallbackScheme == null ? DEFAULT_FONT_NAME : fallbackScheme.getEditorFontName();
        }
        return null;
    }

    public boolean useLigatures() {
        return this.myUseLigatures;
    }

    public void setUseLigatures(boolean useLigatures) {
        if (useLigatures != this.myUseLigatures) {
            this.myUseLigatures = useLigatures;
            if (this.myChangeListener != null) {
                this.myChangeListener.run();
            }
        }
    }

    public String toString() {
        return "Effective font families: " + this.myEffectiveFontFamilies;
    }
}

