/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.reflect;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.openapi.util.Factory;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElementRef;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JamStringAttributeMeta<T, JamType>
extends JamAttributeMeta<JamType> {
    protected final JamConverter<T> myConverter;

    public JamStringAttributeMeta(String attrName, JamConverter<T> converter) {
        super(attrName);
        this.myConverter = converter;
    }

    public JamConverter<T> getConverter() {
        return this.myConverter;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JamStringAttributeMeta that = (JamStringAttributeMeta)o;
        return this.myConverter.equals(that.myConverter);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myConverter.hashCode();
        return result;
    }

    public static class Single<T>
    extends JamStringAttributeMeta<T, JamStringAttributeElement<T>> {
        public static final Single<String> NAME_STRING_VALUE_META = Single.singleString("name");

        public Single(String attrName, JamConverter<T> converter) {
            super(attrName, converter);
        }

        @NotNull
        public JamStringAttributeElement<T> getJam(PsiElementRef<PsiAnnotation> anno, final @NotNull Factory<T> defaultValue) {
            if (defaultValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/intellij/jam/reflect/JamStringAttributeMeta$Single", "getJam"));
            }
            JamStringAttributeElement jamStringAttributeElement = new JamStringAttributeElement<T>(anno, this.getAttributeLink().getAttributeName(), this.myConverter){

                @Override
                public T getValue() {
                    Object value = super.getValue();
                    return value == null ? defaultValue.create() : value;
                }
            };
            if (jamStringAttributeElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/reflect/JamStringAttributeMeta$Single", "getJam"));
            }
            return jamStringAttributeElement;
        }

        @Override
        @NotNull
        public JamStringAttributeElement<T> getJam(PsiElementRef<PsiAnnotation> anno) {
            JamStringAttributeElement jamStringAttributeElement = new JamStringAttributeElement(anno, this.getAttributeLink().getAttributeName(), this.myConverter);
            if (jamStringAttributeElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/reflect/JamStringAttributeMeta$Single", "getJam"));
            }
            return jamStringAttributeElement;
        }
    }

    public static class Collection<T>
    extends JamStringAttributeMeta<T, List<JamStringAttributeElement<T>>> {
        public Collection(String attrName, JamConverter<T> converter) {
            super(attrName, converter);
        }

        @Override
        @NotNull
        public List<JamStringAttributeElement<T>> getJam(PsiElementRef<PsiAnnotation> anno) {
            List<JamStringAttributeElement<T>> list = this.getCollectionJam(anno, psiAnnotationMemberValue -> new JamStringAttributeElement((PsiAnnotationMemberValue)psiAnnotationMemberValue, this.myConverter));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/reflect/JamStringAttributeMeta$Collection", "getJam"));
            }
            return list;
        }

        public JamStringAttributeElement<T> addAttribute(PsiElementRef<PsiAnnotation> annoRef, String stringValue) {
            return new JamStringAttributeElement(Collection.addAttribute(annoRef, "\"" + stringValue + "\"", this.getAttributeLink()), this.myConverter);
        }
    }
}

