/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.reflect;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamInstantiator;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiAnnotationPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.util.Consumer;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JamAnnotationAttributeMeta<T extends JamElement, JamType>
extends JamAttributeMeta<JamType> {
    protected final JamAnnotationMeta myAnnoMeta;
    protected final SemKey<T> myJamKey;
    protected final JamInstantiator<PsiAnnotation, T> myInstantiator;
    private final List<PairConsumer<T, Consumer<PomTarget>>> myPomTargetProducers = ContainerUtil.newArrayList();
    private final PsiAnnotationPattern myAnnoPattern;

    private JamAnnotationAttributeMeta(String attrName, JamAnnotationMeta annoMeta, JamInstantiator<PsiAnnotation, T> instantiator) {
        super(attrName);
        this.myAnnoMeta = annoMeta;
        this.myInstantiator = instantiator;
        this.myJamKey = JamService.JAM_ELEMENT_KEY.subKey(attrName, new SemKey[0]);
        this.myAnnoPattern = PsiJavaPatterns.psiAnnotation().qName(this.myAnnoMeta.getAnnoName());
    }

    public JamAnnotationAttributeMeta<T, JamType> addPomTargetProducer(@NotNull PairConsumer<T, Consumer<PomTarget>> producer) {
        if (producer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/jam/reflect/JamAnnotationAttributeMeta", "addPomTargetProducer"));
        }
        this.myPomTargetProducers.add(producer);
        return this;
    }

    public List<PomTarget> getAssociatedTargets(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jam/reflect/JamAnnotationAttributeMeta", "getAssociatedTargets"));
        }
        ArrayList list = ContainerUtil.newArrayList();
        Consumer targetConsumer = target -> list.add(target);
        for (PairConsumer<T, Consumer<PomTarget>> function : this.myPomTargetProducers) {
            function.consume(element, (Object)targetConsumer);
        }
        return list;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JamAnnotationAttributeMeta that = (JamAnnotationAttributeMeta)o;
        if (this.myAnnoMeta != null ? !this.myAnnoMeta.equals(that.myAnnoMeta) : that.myAnnoMeta != null) {
            return false;
        }
        return !(this.myInstantiator != null ? !this.myInstantiator.equals(that.myInstantiator) : that.myInstantiator != null);
    }

    @Override
    public int hashCode() {
        int result = this.myAnnoMeta != null ? this.myAnnoMeta.hashCode() : 0;
        result = 31 * result + (this.myInstantiator != null ? this.myInstantiator.hashCode() : 0);
        return result;
    }

    public JamAnnotationMeta getAnnotationMeta() {
        return this.myAnnoMeta;
    }

    public JamInstantiator<PsiAnnotation, T> getInstantiator() {
        return this.myInstantiator;
    }

    public void registerSem(SemRegistrar registrar, ElementPattern<PsiAnnotation> annotationPattern, JamAnnotationMeta parentMeta) {
        PsiAnnotationPattern annoPattern = this.myAnnoPattern.insideAnnotationAttribute(this.getAttributeLink().getAttributeName(), annotationPattern);
        registrar.registerSemElementProvider(this.myJamKey, annoPattern, new JamCreator(parentMeta));
        this.myAnnoMeta.registerNestedSem(registrar, annoPattern, parentMeta);
    }

    protected class JamCreator
    implements NullableFunction<PsiAnnotation, T> {
        private final JamAnnotationMeta myParentMeta;

        private JamCreator(JamAnnotationMeta parentMeta) {
            this.myParentMeta = parentMeta;
        }

        public T fun(PsiAnnotation annotation) {
            PsiAnnotation parentAnno = PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiAnnotation.class, true);
            assert (parentAnno != null);
            JamAnnotationMeta annotationMeta = SemService.getSemService(parentAnno.getProject()).getSemElement(this.myParentMeta.getMetaKey(), parentAnno);
            if (annotationMeta == this.myParentMeta) {
                return JamAnnotationAttributeMeta.this.myInstantiator.instantiate(PsiElementRef.real(annotation));
            }
            return null;
        }
    }

    public static final class Collection<T extends JamElement>
    extends JamAnnotationAttributeMeta<T, List<T>> {
        public Collection(String attrName, @NotNull JamAnnotationMeta annoMeta, JamInstantiator<PsiAnnotation, T> instantiator) {
            if (annoMeta == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annoMeta", "com/intellij/jam/reflect/JamAnnotationAttributeMeta$Collection", "<init>"));
            }
            super(attrName, annoMeta, instantiator);
        }

        @Override
        @NotNull
        public List<T> getJam(PsiElementRef<PsiAnnotation> anno) {
            List list = this.getCollectionJam(anno, psiAnnotationMemberValue -> this.getJam((PsiAnnotationMemberValue)psiAnnotationMemberValue));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/reflect/JamAnnotationAttributeMeta$Collection", "getJam"));
            }
            return list;
        }

        @Nullable
        private T getJam(PsiAnnotationMemberValue element) {
            if (element instanceof PsiAnnotation) {
                return JamService.getJamService(element.getProject()).getJamElement(this.myJamKey, (PsiElement)element);
            }
            return null;
        }

        @NotNull
        public T addAttribute(PsiElementRef<PsiAnnotation> annoRef) {
            JamElement jamElement = (JamElement)ObjectUtils.assertNotNull(this.getJam(Collection.addAttribute(annoRef, "@" + this.myAnnoMeta.getAnnoName(), this.getAttributeLink())));
            if (jamElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/reflect/JamAnnotationAttributeMeta$Collection", "addAttribute"));
            }
            return (T)jamElement;
        }

        public Collection<T> addPomTargetProducer(@NotNull PairConsumer<T, Consumer<PomTarget>> producer) {
            if (producer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/jam/reflect/JamAnnotationAttributeMeta$Collection", "addPomTargetProducer"));
            }
            super.addPomTargetProducer(producer);
            return this;
        }
    }

    public static final class Single<T extends JamElement>
    extends JamAnnotationAttributeMeta<T, T> {
        public Single(String attrName, JamAnnotationMeta annoMeta, JamInstantiator<PsiAnnotation, T> instantiator) {
            super(attrName, annoMeta, instantiator);
        }

        @Override
        @NotNull
        public T getJam(PsiElementRef<PsiAnnotation> anno) {
            PsiAnnotation psiElement = anno.getPsiElement();
            assert (psiElement != null);
            JamElement jamElement = (JamElement)ObjectUtils.assertNotNull(JamService.getJamService(anno.getPsiManager().getProject()).getJamElement(this.myJamKey, (PsiElement)psiElement));
            if (jamElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/reflect/JamAnnotationAttributeMeta$Single", "getJam"));
            }
            return (T)jamElement;
        }
    }
}

