/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.reflect;

import com.intellij.jam.JamElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamChildrenQuery;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JamAnnotatedChildrenQuery<Jam extends JamElement>
extends JamChildrenQuery<Jam> {
    private final String myAnnoName;

    public JamAnnotatedChildrenQuery(@NonNls JamAnnotationMeta meta) {
        this.myAnnoName = meta.getAnnoName();
    }

    @Nullable
    protected abstract JamMemberMeta<?, ? extends Jam> getMemberMeta(@NotNull PsiModifierListOwner var1);

    @Override
    public JamMemberMeta<?, ? extends Jam> getMeta(@NotNull PsiModifierListOwner member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/jam/reflect/JamAnnotatedChildrenQuery", "getMeta"));
        }
        JamMemberMeta<?, Jam> memberMeta = this.getMemberMeta(member);
        return memberMeta != null && JamAnnotatedChildrenQuery.isAnnotated(member, this.myAnnoName) ? memberMeta : null;
    }

    public String getAnnoName() {
        return this.myAnnoName;
    }

    protected abstract PsiModifierListOwner[] getAllChildren(@NotNull PsiMember var1);

    @Override
    public List<Jam> findChildren(@NotNull PsiMember parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/jam/reflect/JamAnnotatedChildrenQuery", "findChildren"));
        }
        ArrayList list = ContainerUtil.newArrayList();
        for (PsiModifierListOwner child : this.getAllChildren(parent)) {
            JamMemberMeta<?, Jam> meta;
            if (!JamAnnotatedChildrenQuery.isAnnotated(child, this.myAnnoName) || (meta = this.getMemberMeta(child)) == null) continue;
            ContainerUtil.addIfNotNull((Collection)list, meta.getJamElement(child));
        }
        return list;
    }
}

