/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.jam.JamSimpleReferenceConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class JamSimpleReference<T>
extends PsiReferenceBase<PsiLiteral> {
    private final JamStringAttributeElement<T> myContext;
    private final JamSimpleReferenceConverter<T> myConverter;

    public JamSimpleReference(JamStringAttributeElement<T> context) {
        super((PsiElement)ObjectUtils.assertNotNull((Object)context.getPsiLiteral()));
        this.myContext = context;
        this.myConverter = (JamSimpleReferenceConverter)context.getConverter();
    }

    @Override
    public PsiElement resolve() {
        T result = this.myConverter.fromString(this.getValue(), this.myContext);
        if (result == null) {
            return null;
        }
        PsiElement element = this.myConverter.getPsiElementFor(result);
        return element == null ? this.myContext.getPsiLiteral() : element;
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        LookupElement[] lookupElementArray = this.myConverter.getLookupVariants(this.myContext);
        if (lookupElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/JamSimpleReference", "getVariants"));
        }
        return lookupElementArray;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jam/JamSimpleReference", "bindToElement"));
        }
        return this.myConverter.bindReference(this.myContext, element);
    }
}

