/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.annotations.NotNull;

public abstract class PluginReplacement
implements PluginAware {
    public static final ExtensionPointName<PluginReplacement> EP_NAME = ExtensionPointName.create((String)"com.intellij.pluginReplacement");
    private final String myNewPluginId;
    private PluginDescriptor myPluginDescriptor;

    protected PluginReplacement(String newPluginId) {
        this.myNewPluginId = newPluginId;
    }

    @NotNull
    public String getReplacementMessage(@NotNull IdeaPluginDescriptor oldPlugin, @NotNull IdeaPluginDescriptor newPlugin) {
        if (oldPlugin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldPlugin", "com/intellij/ide/plugins/PluginReplacement", "getReplacementMessage"));
        }
        if (newPlugin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newPlugin", "com/intellij/ide/plugins/PluginReplacement", "getReplacementMessage"));
        }
        String string = IdeBundle.message("plugin.manager.replace.plugin.0.by.plugin.1", oldPlugin.getName(), newPlugin.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginReplacement", "getReplacementMessage"));
        }
        return string;
    }

    public final void setPluginDescriptor(PluginDescriptor pluginDescriptor) {
        this.myPluginDescriptor = pluginDescriptor;
    }

    public final PluginDescriptor getOldPluginDescriptor() {
        return this.myPluginDescriptor;
    }

    public final String getNewPluginId() {
        return this.myNewPluginId;
    }
}

