/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BinaryOutputReader;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryOSProcessHandler
extends OSProcessHandler {
    private final BufferExposingByteArrayOutputStream myOutput;

    public BinaryOSProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/BinaryOSProcessHandler", "<init>"));
        }
        super(commandLine);
        this.myOutput = new BufferExposingByteArrayOutputStream();
    }

    public BinaryOSProcessHandler(@NotNull Process process, @NotNull String commandLine, @Nullable Charset charset) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/BinaryOSProcessHandler", "<init>"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/BinaryOSProcessHandler", "<init>"));
        }
        super(process, commandLine, charset);
        this.myOutput = new BufferExposingByteArrayOutputStream();
    }

    @NotNull
    public byte[] getOutput() {
        byte[] byArray = this.myOutput.toByteArray();
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/BinaryOSProcessHandler", "getOutput"));
        }
        return byArray;
    }

    @NotNull
    protected BaseDataReader createOutputDataReader() {
        SimpleBinaryReader simpleBinaryReader = new SimpleBinaryReader(this.myProcess.getInputStream(), this.readerOptions().policy());
        if (simpleBinaryReader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/BinaryOSProcessHandler", "createOutputDataReader"));
        }
        return simpleBinaryReader;
    }

    private class SimpleBinaryReader
    extends BinaryOutputReader {
        private SimpleBinaryReader(InputStream stream, BaseDataReader.SleepingPolicy policy) {
            super(stream, policy);
            this.start("output stream of " + BinaryOSProcessHandler.this.myPresentableName);
        }

        protected void onBinaryAvailable(@NotNull byte[] data, int size) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/execution/process/BinaryOSProcessHandler$SimpleBinaryReader", "onBinaryAvailable"));
            }
            BinaryOSProcessHandler.this.myOutput.write(data, 0, size);
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/execution/process/BinaryOSProcessHandler$SimpleBinaryReader", "executeOnPooledThread"));
            }
            Future<?> future = BinaryOSProcessHandler.this.executeOnPooledThread(runnable);
            if (future == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/BinaryOSProcessHandler$SimpleBinaryReader", "executeOnPooledThread"));
            }
            return future;
        }
    }
}

