/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MetaAnnotationUtil {
    private static final TObjectHashingStrategy<PsiClass> HASHING_STRATEGY = new TObjectHashingStrategy<PsiClass>(){

        public int computeHashCode(PsiClass object) {
            String qualifiedName = object.getQualifiedName();
            return qualifiedName == null ? 0 : qualifiedName.hashCode();
        }

        public boolean equals(PsiClass o1, PsiClass o2) {
            return Comparing.equal((String)o1.getQualifiedName(), (String)o2.getQualifiedName());
        }
    };

    public static Collection<PsiClass> getAnnotationTypesWithChildren(@NotNull Module module, String annotationName, boolean includeTests) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/MetaAnnotationUtil", "getAnnotationTypesWithChildren"));
        }
        Map map = (Map)CachedValuesManager.getManager(module.getProject()).getCachedValue(module, () -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/MetaAnnotationUtil", "lambda$getAnnotationTypesWithChildren$1"));
            }
            ConcurrentFactoryMap factoryMap = ConcurrentFactoryMap.createConcurrentMap(key -> {
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/MetaAnnotationUtil", "lambda$null$0"));
                }
                GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module, (Boolean)key.getSecond());
                GlobalSearchScope effectiveSearchScope = MetaAnnotationUtil.getAllAnnotationFilesScope(module.getProject()).intersectWith(scope);
                return MetaAnnotationUtil.getAnnotationTypesWithChildren((String)key.getFirst(), module.getProject(), effectiveSearchScope);
            });
            return CachedValueProvider.Result.create(factoryMap, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        });
        return (Collection)map.get(Pair.create((Object)annotationName, (Object)includeTests));
    }

    public static Set<PsiClass> getChildren(PsiClass psiClass, GlobalSearchScope scope) {
        if (AnnotationTargetUtil.findAnnotationTarget(psiClass, PsiAnnotation.TargetType.ANNOTATION_TYPE, PsiAnnotation.TargetType.TYPE) == null) {
            return Collections.emptySet();
        }
        String name = psiClass.getQualifiedName();
        if (name == null) {
            return Collections.emptySet();
        }
        THashSet result = new THashSet(HASHING_STRATEGY);
        AnnotatedElementsSearch.searchPsiClasses(psiClass, scope).forEach((Processor<PsiClass>)((Processor)arg_0 -> MetaAnnotationUtil.lambda$getChildren$2((Set)result, arg_0)));
        return result;
    }

    public static Collection<PsiClass> getAnnotatedTypes(Module module, Key<CachedValue<Collection<PsiClass>>> key, String annotationName) {
        return CachedValuesManager.getManager(module.getProject()).getCachedValue(module, key, () -> {
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module, false);
            PsiClass psiClass = JavaPsiFacade.getInstance(module.getProject()).findClass(annotationName, scope);
            Collection<Object> classes = psiClass == null || !psiClass.isAnnotationType() ? Collections.emptyList() : MetaAnnotationUtil.getChildren(psiClass, scope);
            return new CachedValueProvider.Result(classes, new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        }, false);
    }

    @NotNull
    private static Collection<PsiClass> getAnnotationTypesWithChildren(String annotationName, Project project, GlobalSearchScope scope) {
        PsiClass psiClass = JavaPsiFacade.getInstance(project).findClass(annotationName, scope);
        if (psiClass == null || !psiClass.isAnnotationType()) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/MetaAnnotationUtil", "getAnnotationTypesWithChildren"));
            }
            return list;
        }
        THashSet classes = new THashSet(HASHING_STRATEGY);
        MetaAnnotationUtil.collectClassWithChildren(psiClass, (Set<PsiClass>)classes, scope);
        THashSet tHashSet = classes;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/MetaAnnotationUtil", "getAnnotationTypesWithChildren"));
        }
        return tHashSet;
    }

    private static GlobalSearchScope getAllAnnotationFilesScope(Project project) {
        return (GlobalSearchScope)CachedValuesManager.getManager(project).getCachedValue(project, () -> {
            GlobalSearchScope scope = GlobalSearchScope.allScope(project);
            HashSet<VirtualFile> allAnnotationFiles = new HashSet<VirtualFile>();
            for (PsiClass javaLangAnnotation : JavaPsiFacade.getInstance(project).findClasses("java.lang.annotation.Annotation", scope)) {
                DirectClassInheritorsSearch.search(javaLangAnnotation, scope, false).forEach((Processor<PsiClass>)((Processor)annotationClass -> {
                    ContainerUtil.addIfNotNull((Collection)allAnnotationFiles, (Object)PsiUtilCore.getVirtualFile(annotationClass));
                    return true;
                }));
            }
            return CachedValueProvider.Result.createSingleDependency(GlobalSearchScope.filesWithLibrariesScope(project, allAnnotationFiles), PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        });
    }

    private static void collectClassWithChildren(PsiClass psiClass, Set<PsiClass> classes, GlobalSearchScope scope) {
        classes.add(psiClass);
        for (PsiClass aClass : MetaAnnotationUtil.getChildren(psiClass, scope)) {
            if (classes.contains(aClass)) continue;
            MetaAnnotationUtil.collectClassWithChildren(aClass, classes, scope);
        }
    }

    public static boolean isMetaAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/MetaAnnotationUtil", "isMetaAnnotated"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/codeInsight/MetaAnnotationUtil", "isMetaAnnotated"));
        }
        if (AnnotationUtil.isAnnotated(listOwner, annotations, false)) {
            return true;
        }
        List<PsiClass> resolvedAnnotations = MetaAnnotationUtil.getResolvedClassesInAnnotationsList(listOwner);
        for (String annotationFQN : annotations) {
            for (PsiClass psiClass : resolvedAnnotations) {
                ConcurrentFactoryMap cachedValue = (ConcurrentFactoryMap)CachedValuesManager.getCachedValue(psiClass, () -> new CachedValueProvider.Result<ConcurrentFactoryMap>(ConcurrentFactoryMap.createConcurrentMap(anno -> MetaAnnotationUtil.isMetaAnnotated(psiClass, anno, new HashSet<PsiClass>())), PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT));
                if (!((Boolean)cachedValue.getOrDefault((Object)annotationFQN, (Object)false)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isMetaAnnotated(PsiClass aClass, String annotation, Set<PsiClass> visited) {
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, annotation, false)) {
            return true;
        }
        List<PsiClass> resolvedAnnotations = MetaAnnotationUtil.getResolvedClassesInAnnotationsList(aClass);
        for (PsiClass resolvedAnnotation : resolvedAnnotations) {
            if (!visited.add(resolvedAnnotation) || !MetaAnnotationUtil.isMetaAnnotated(resolvedAnnotation, annotation, visited)) continue;
            return true;
        }
        return false;
    }

    private static List<PsiClass> getResolvedClassesInAnnotationsList(PsiModifierListOwner owner) {
        PsiModifierList modifierList = owner.getModifierList();
        if (modifierList != null) {
            return ContainerUtil.mapNotNull((Object[])modifierList.getApplicableAnnotations(), psiAnnotation -> {
                PsiJavaCodeReferenceElement nameReferenceElement = psiAnnotation.getNameReferenceElement();
                PsiElement resolve = nameReferenceElement != null ? nameReferenceElement.resolve() : null;
                return resolve instanceof PsiClass && ((PsiClass)resolve).isAnnotationType() ? (PsiClass)resolve : null;
            });
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ boolean lambda$getChildren$2(Set result, PsiClass processorResult) {
        if (processorResult.isAnnotationType()) {
            result.add(processorResult);
        }
        return true;
    }
}

