/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.watcher;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.ide.macro.FileDirMacro;
import com.intellij.ide.macro.FileNameMacro;
import com.intellij.ide.macro.FileNameWithoutExtension;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.config.FileTypeBackgroundTaskConsumer;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SassScssTaskConsumerBase
extends FileTypeBackgroundTaskConsumer {
    private static final String COMPILE_PARTIAL_ENV_NAME = "COMPILE_PARTIAL";
    private final String myDisplayName;
    private final String myExecutableName;
    private final String myDescription;

    public SassScssTaskConsumerBase(LanguageFileType fileType, String executableName, String description) {
        super((FileType)fileType);
        this.myDisplayName = fileType.getLanguage().getDisplayName();
        this.myExecutableName = executableName;
        this.myDescription = description;
    }

    public boolean isAvailable(@NotNull VirtualFile file, @NotNull EnvironmentVariablesData data) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/scss/watcher/SassScssTaskConsumerBase", "isAvailable"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/plugins/scss/watcher/SassScssTaskConsumerBase", "isAvailable"));
        }
        boolean available = super.isAvailable(file, data);
        if (available && file.getName().startsWith("_")) {
            available = Boolean.parseBoolean((String)data.getEnvs().get(COMPILE_PARTIAL_ENV_NAME));
        }
        return available;
    }

    @NotNull
    public TaskOptions getOptionsTemplate() {
        TaskOptions options = new TaskOptions();
        options.setName(this.myDisplayName);
        options.setDescription(this.myDescription);
        options.setFileExtension(this.getFileType().getDefaultExtension());
        options.setScopeName(PsiBundle.message((String)"psi.search.scope.project", (Object[])new Object[0]));
        String file2css = "$" + new FileNameMacro().getName() + "$:$" + new FileNameWithoutExtension().getName() + "$.css";
        options.setArguments("--no-cache --update " + file2css);
        options.setOutput("$" + new FileNameWithoutExtension().getName() + "$.css:$" + new FileNameWithoutExtension().getName() + "$.css.map");
        options.setWorkingDir("$" + new FileDirMacro().getName() + "$");
        TaskOptions taskOptions = options;
        if (taskOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/watcher/SassScssTaskConsumerBase", "getOptionsTemplate"));
        }
        return taskOptions;
    }

    public void additionalConfiguration(@NotNull Project project, @Nullable PsiFile file, @NotNull TaskOptions options) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/scss/watcher/SassScssTaskConsumerBase", "additionalConfiguration"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/plugins/scss/watcher/SassScssTaskConsumerBase", "additionalConfiguration"));
        }
        super.additionalConfiguration(project, file, options);
        options.setProgram(SassScssTaskConsumerBase.findExecutableInPath((String)this.myExecutableName));
    }
}

