/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.psi;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.scss.SCSSElementTypes;
import org.jetbrains.plugins.scss.psi.SASSSCSSElementVisitor;
import org.jetbrains.plugins.scss.psi.SCSSElementGenerator;
import org.jetbrains.plugins.scss.psi.SassScssElement;
import org.jetbrains.plugins.scss.references.SassScssVariableReference;

public class SassScssVariableImpl
extends CompositePsiElement
implements PsiNamedElement,
SassScssElement {
    protected SassScssVariableImpl() {
        super(SCSSElementTypes.SCSS_VARIABLE);
    }

    public PsiReference getReference() {
        return new SassScssVariableReference(this);
    }

    public PsiElement setName(@NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "org/jetbrains/plugins/scss/psi/SassScssVariableImpl", "setName"));
        }
        SassScssVariableImpl variable = SCSSElementGenerator.createSCSSVariable(this.getProject(), newName);
        return this.replace((PsiElement)variable);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/plugins/scss/psi/SassScssVariableImpl", "accept"));
        }
        if (visitor instanceof SASSSCSSElementVisitor) {
            ((SASSSCSSElementVisitor)visitor).visitSassScssVariable(this);
            return;
        }
        super.accept(visitor);
    }

    public int getTextOffset() {
        int startOffset = this.getTextRange().getStartOffset();
        return this.getTextLength() > 0 ? startOffset + 1 : startOffset;
    }

    @NotNull
    public String getName() {
        String text = this.getText();
        String string = StringUtil.startsWithChar((CharSequence)text, (char)'$') ? text.substring(1) : text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/psi/SassScssVariableImpl", "getName"));
        }
        return string;
    }
}

