/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.indexing.AdditionalIndexedRootsScope;
import java.util.Collection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSFileType;
import org.jetbrains.plugins.sass.extensions.SassExtensionFunctionInfo;
import org.jetbrains.plugins.sass.extensions.SassRubyIntegrationHelper;
import org.jetbrains.plugins.scss.SCSSFileType;
import org.jetbrains.plugins.scss.index.SassScssIndexedRootProvider;
import org.jetbrains.plugins.scss.psi.SCSSEachStatementImpl;
import org.jetbrains.plugins.scss.psi.SCSSForStatementImpl;
import org.jetbrains.plugins.scss.psi.SCSSIfStatementImpl;
import org.jetbrains.plugins.scss.psi.SCSSWhileStatementImpl;
import org.jetbrains.plugins.scss.psi.SassScssFunctionDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssFunctionDeclarationImpl;
import org.jetbrains.plugins.scss.psi.SassScssInclude;
import org.jetbrains.plugins.scss.psi.SassScssMixinDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssPlaceholderSelector;
import org.jetbrains.plugins.scss.psi.SassScssPropertyRuleset;
import org.jetbrains.plugins.scss.psi.SassScssVariableDeclaration;

public class SASSSCSSLangUtil {
    public static final int IMPORTED_ELEMENT_PRIORITY = 30;
    private static final int KEYWORD_ELEMENT_PRIORITY = 70;
    private static final String NMSTART = "(([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))";
    private static final String NMCHAR = "((([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))|([0-9_-]))";
    private static final String IDENT = "[_-]?(([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))((([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))|([0-9_-]))*";
    private static final Pattern IDENT_PATTERN = Pattern.compile("[_-]?(([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))((([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))|([0-9_-]))*");
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$?[_-]?(([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))((([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))|([0-9_-]))*");
    public static final Class[] ELEMENT_SCOPES = new Class[]{PsiFile.class, CssRuleset.class, CssAtRule.class, SassScssMixinDeclaration.class, SCSSForStatementImpl.class, SCSSEachStatementImpl.class, SCSSWhileStatementImpl.class, SCSSIfStatementImpl.class, SassScssInclude.class, SassScssFunctionDeclarationImpl.class};

    public static boolean isValidScope(PsiElement element) {
        for (Class scope : ELEMENT_SCOPES) {
            if (!scope.isInstance(element)) continue;
            return true;
        }
        return false;
    }

    @Contract(value="!null -> !null")
    @Nullable
    public static String normalizeName(@Nullable String name) {
        if (name == null || !StringUtil.containsChar((String)name, (char)'-')) {
            return name;
        }
        return StringUtil.replaceChar((String)StringUtil.notNullize((String)name), (char)'-', (char)'_');
    }

    public static boolean isValidVariableName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/scss/SASSSCSSLangUtil", "isValidVariableName"));
        }
        return VARIABLE_PATTERN.matcher(name).matches();
    }

    public static boolean isValidMixinName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/scss/SASSSCSSLangUtil", "isValidMixinName"));
        }
        return IDENT_PATTERN.matcher(name).matches();
    }

    public static boolean isValidFunctionName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/scss/SASSSCSSLangUtil", "isValidFunctionName"));
        }
        return IDENT_PATTERN.matcher(name).matches();
    }

    public static boolean isValidSelectorName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/scss/SASSSCSSLangUtil", "isValidSelectorName"));
        }
        return IDENT_PATTERN.matcher(name).matches();
    }

    public static String restoreFullPropertyName(@NotNull String propertyName, @Nullable PsiElement context) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/plugins/scss/SASSSCSSLangUtil", "restoreFullPropertyName"));
        }
        StringBuilder result = new StringBuilder(propertyName);
        CssDeclaration declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)context, CssDeclaration.class, (boolean)false);
        context = declaration != null ? declaration.getParent() : context;
        SassScssPropertyRuleset propertyRuleset = (SassScssPropertyRuleset)PsiTreeUtil.getParentOfType((PsiElement)context, SassScssPropertyRuleset.class);
        while (propertyRuleset != null) {
            String namespace = propertyRuleset.getNamespace();
            if (!namespace.isEmpty()) {
                result.insert(0, '-');
                result.insert(0, namespace);
            }
            propertyRuleset = (SassScssPropertyRuleset)PsiTreeUtil.getParentOfType((PsiElement)propertyRuleset, SassScssPropertyRuleset.class);
        }
        return result.toString();
    }

    public static boolean isVisibleDeclaration(@NotNull PsiElement declaration, @NotNull PsiElement reference) {
        CssRuleset rulesetParent;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/plugins/scss/SASSSCSSLangUtil", "isVisibleDeclaration"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/plugins/scss/SASSSCSSLangUtil", "isVisibleDeclaration"));
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)reference, CssSelectorList.class, (boolean)false) != null && (rulesetParent = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)reference, CssRuleset.class)) != null) {
            reference = rulesetParent;
        }
        if (declaration.getTextOffset() > reference.getTextOffset() && declaration.getContainingFile().getOriginalFile() == reference.getContainingFile().getOriginalFile()) {
            return false;
        }
        PsiElement declarationScope = SASSSCSSLangUtil.getOriginalScope(declaration);
        PsiElement originalScope = SASSSCSSLangUtil.getOriginalScope(reference);
        return declarationScope instanceof PsiFile || originalScope != null && PsiTreeUtil.isAncestor((PsiElement)declarationScope, (PsiElement)originalScope, (boolean)false);
    }

    @Nullable
    public static PsiElement getOriginalScope(PsiElement reference) {
        PsiElement myElementScope = PsiTreeUtil.getParentOfType((PsiElement)reference, (Class[])ELEMENT_SCOPES);
        if (myElementScope instanceof SassScssInclude && myElementScope.getParent() instanceof CssRuleset) {
            myElementScope = myElementScope.getParent();
        }
        PsiElement originalScope = myElementScope != null ? CompletionUtil.getOriginalElement((PsiElement)myElementScope) : null;
        return originalScope == null && myElementScope != null ? SASSSCSSLangUtil.getOriginalScope(myElementScope) : originalScope;
    }

    @Nullable
    public static ResolveResult filterOverridedResults(Collection<ResolveResult> result, PsiElement reference) {
        ResolveResult singleResult = null;
        PsiFile originalFile = reference.getContainingFile();
        for (ResolveResult resolveResult : result) {
            PsiElement resolvedElement = resolveResult.getElement();
            if (resolvedElement == null || originalFile != resolvedElement.getContainingFile()) continue;
            if (singleResult == null) {
                singleResult = resolveResult;
                continue;
            }
            PsiElement singleResultElement = singleResult.getElement();
            if (singleResultElement == null || resolvedElement.getTextOffset() <= singleResultElement.getTextOffset()) continue;
            singleResult = resolveResult;
        }
        return singleResult;
    }

    public static LookupElement createKeywordLookupItem(String keyword) {
        return SASSSCSSLangUtil.createKeywordLookupItem(keyword, null);
    }

    public static LookupElement createKeywordLookupItem(String keyword, @Nullable InsertHandler<LookupElement> insertHandler) {
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)keyword).bold().withInsertHandler(insertHandler), (double)70.0);
    }

    @NotNull
    public static LookupElement createMixinLookupItem(SassScssMixinDeclaration declaration, boolean validResult, @NotNull String currentPrefix) {
        if (currentPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentPrefix", "org/jetbrains/plugins/scss/SASSSCSSLangUtil", "createMixinLookupItem"));
        }
        ItemPresentation itemPresentation = declaration.getPresentation();
        String tailText = validResult ? declaration.getParametersString() : declaration.getParametersString() + " implicitly imported";
        String declarationName = SASSSCSSLangUtil.normalizedDeclarationName(declaration.getName(), currentPrefix);
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.createWithSmartPointer((String)declarationName, (PsiElement)declaration).withIcon(itemPresentation.getIcon(false)).withBoldness(validResult).withTailText(tailText, true).withInsertHandler((InsertHandler)(declaration.hasParameters() ? ParenthesesInsertHandler.WITH_PARAMETERS : null)).withTypeText(itemPresentation.getLocationString(), true), (double)(validResult ? 30.0 : 0.0));
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/SASSSCSSLangUtil", "createMixinLookupItem"));
        }
        return lookupElement;
    }

    @NotNull
    public static LookupElement createVariableLookupItem(@NotNull SassScssVariableDeclaration declaration, boolean validResult, @NotNull String currentPrefix) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/plugins/scss/SASSSCSSLangUtil", "createVariableLookupItem"));
        }
        if (currentPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentPrefix", "org/jetbrains/plugins/scss/SASSSCSSLangUtil", "createVariableLookupItem"));
        }
        ItemPresentation itemPresentation = declaration.getPresentation();
        String tailText = validResult ? "" : " implicitly imported";
        String declarationName = SASSSCSSLangUtil.normalizedDeclarationName(declaration.getName(), currentPrefix);
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.createWithSmartPointer((String)declarationName, (PsiElement)declaration).withIcon(itemPresentation.getIcon(false)).withBoldness(validResult).withTailText(tailText, true).withTypeText(itemPresentation.getLocationString(), true), (double)(validResult ? 30.0 : 0.0));
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/SASSSCSSLangUtil", "createVariableLookupItem"));
        }
        return lookupElement;
    }

    public static LookupElement createFunctionLookupItem(@NotNull SassScssFunctionDeclaration declaration, boolean validResult, @Nullable String currentPrefix) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/plugins/scss/SASSSCSSLangUtil", "createFunctionLookupItem"));
        }
        ItemPresentation itemPresentation = declaration.getPresentation();
        String argumentsString = declaration.getParametersString();
        String tailText = validResult ? argumentsString : argumentsString + " implicitly imported";
        String declarationName = SASSSCSSLangUtil.normalizedDeclarationName(declaration.getName(), currentPrefix);
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.createWithSmartPointer((String)declarationName, (PsiElement)declaration).withIcon(itemPresentation.getIcon(false)).withBoldness(validResult).withTailText(tailText, true).withInsertHandler((InsertHandler)(argumentsString.isEmpty() || "()".equals(argumentsString) ? ParenthesesInsertHandler.NO_PARAMETERS : ParenthesesInsertHandler.WITH_PARAMETERS)).withTypeText(itemPresentation.getLocationString(), true), (double)(validResult ? 30.0 : 0.0));
    }

    public static LookupElement createPlaceholderSelectorLookup(SassScssPlaceholderSelector selector, boolean validResult) {
        ItemPresentation itemPresentation = selector.getPresentation();
        String tailText = validResult ? "" : " implicitly imported";
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.createWithSmartPointer((String)selector.getName(), (PsiElement)selector).withIcon(itemPresentation.getIcon(false)).withBoldness(validResult).withTailText(tailText, true).withTypeText(itemPresentation.getLocationString(), true), (double)(validResult ? 30.0 : 0.0));
    }

    public static LookupElement createCustomFunctionLookupItem(@NotNull SassExtensionFunctionInfo functionInfo, @Nullable String currentPrefix) {
        if (functionInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionInfo", "org/jetbrains/plugins/scss/SASSSCSSLangUtil", "createCustomFunctionLookupItem"));
        }
        String filePath = functionInfo.getFilePath();
        String fileName = PathUtil.getFileName((String)filePath);
        String argumentString = functionInfo.getArgumentsString();
        String declarationName = SASSSCSSLangUtil.normalizedDeclarationName(functionInfo.getName(), currentPrefix);
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)functionInfo, (String)declarationName).withIcon(AllIcons.Nodes.Function).withTailText("(" + argumentString + ")", true).withInsertHandler((InsertHandler)(argumentString.isEmpty() ? ParenthesesInsertHandler.NO_PARAMETERS : ParenthesesInsertHandler.WITH_PARAMETERS)).withTypeText(fileName.isEmpty() ? filePath : fileName, true), (double)30.0);
    }

    public static SearchScope restrictedBySassFilesScope(@NotNull SearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/scss/SASSSCSSLangUtil", "restrictedBySassFilesScope"));
        }
        return scope instanceof GlobalSearchScope ? GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)scope), (FileType[])new FileType[]{SASSFileType.SASS, SCSSFileType.SCSS}) : scope;
    }

    public static GlobalSearchScope searchScopeWithSassStdlib(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/scss/SASSSCSSLangUtil", "searchScopeWithSassStdlib"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        if (module != null && SassRubyIntegrationHelper.getInstance().isRubyModule(module)) {
            return CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)context);
        }
        return new AdditionalIndexedRootsScope(CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)context), SassScssIndexedRootProvider.class);
    }

    @NotNull
    public static String normalizedDeclarationName(@NotNull String declarationName, @Nullable String currentPrefix) {
        if (declarationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationName", "org/jetbrains/plugins/scss/SASSSCSSLangUtil", "normalizedDeclarationName"));
        }
        if (StringUtil.isNotEmpty((String)currentPrefix)) {
            String normalizedPrefix = SASSSCSSLangUtil.normalizeName(currentPrefix);
            String normalizedName = SASSSCSSLangUtil.normalizeName(declarationName);
            if (normalizedName.startsWith(normalizedPrefix)) {
                String string = currentPrefix + declarationName.substring(currentPrefix.length());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/SASSSCSSLangUtil", "normalizedDeclarationName"));
                }
                return string;
            }
        }
        String string = declarationName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/SASSSCSSLangUtil", "normalizedDeclarationName"));
        }
        return string;
    }

    public static boolean nameEquals(@NotNull String first, @Nullable String second) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "org/jetbrains/plugins/scss/SASSSCSSLangUtil", "nameEquals"));
        }
        if (second == null) {
            return false;
        }
        if (first == second) {
            return true;
        }
        if (first.length() != second.length()) {
            return false;
        }
        for (int i = 0; i < first.length(); ++i) {
            char c2;
            char c1 = first.charAt(i);
            if (c1 == (c2 = second.charAt(i)) || c1 == '_' && c2 == '-' || c1 == '-' && c2 == '_') continue;
            return false;
        }
        return true;
    }
}

