/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.psi.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSElementGenerator;
import org.jetbrains.plugins.sass.psi.SASSDeclarationBlock;
import org.jetbrains.plugins.sass.psi.SASSTokenTypes;

public class SASSDeclarationBlockImpl
extends LazyParseablePsiElement
implements SASSDeclarationBlock {
    private static final TokenSet DECLARATION_FILTER = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_DECLARATION});

    public SASSDeclarationBlockImpl(@NotNull IElementType elementType, CharSequence text) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/plugins/sass/psi/impl/SASSDeclarationBlockImpl", "<init>"));
        }
        super(elementType, text);
    }

    @NotNull
    public CssDeclaration[] getDeclarations() {
        CssDeclaration[] cssDeclarationArray = (CssDeclaration[])this.getChildrenAsPsiElements(DECLARATION_FILTER, CssDeclaration.ARRAY_FACTORY);
        if (cssDeclarationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/psi/impl/SASSDeclarationBlockImpl", "getDeclarations"));
        }
        return cssDeclarationArray;
    }

    @Nullable
    public PsiElement getLBrace() {
        ASTNode node;
        PsiElement firstChild = PsiTreeUtil.getDeepestFirst((PsiElement)this);
        if (firstChild instanceof PsiWhiteSpace) {
            firstChild = PsiTreeUtil.nextVisibleLeaf((PsiElement)firstChild);
        }
        if (firstChild != null && (node = firstChild.getNode()) != null && node.getElementType() == CssElementTypes.CSS_LBRACE) {
            return firstChild;
        }
        return null;
    }

    @Nullable
    public PsiElement getRBrace() {
        ASTNode node;
        PsiElement lastChild = PsiTreeUtil.getDeepestLast((PsiElement)this);
        if (lastChild instanceof PsiWhiteSpace) {
            lastChild = PsiTreeUtil.prevVisibleLeaf((PsiElement)lastChild);
        }
        if (lastChild != null && (node = lastChild.getNode()) != null && node.getElementType() == CssElementTypes.CSS_RBRACE) {
            return lastChild;
        }
        return null;
    }

    public boolean isEqualTo(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SASSDeclarationBlockImpl block = (SASSDeclarationBlockImpl)o;
        return Arrays.equals(this.getDeclarations(), block.getDeclarations());
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/plugins/sass/psi/impl/SASSDeclarationBlockImpl", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssBlock((CssBlock)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public CssDeclaration addDeclaration(@NotNull String name, @NotNull String value, @Nullable CssDeclaration anchor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/sass/psi/impl/SASSDeclarationBlockImpl", "addDeclaration"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/plugins/sass/psi/impl/SASSDeclarationBlockImpl", "addDeclaration"));
        }
        assert (anchor == null || anchor.getParent() == this);
        CssDeclaration cssDeclaration = SASSElementGenerator.createSASSDeclaration(this.getProject(), name, value);
        PsiElement newLine = PsiParserFacade.SERVICE.getInstance((Project)this.getProject()).createWhiteSpaceFromText("\n");
        CssDeclaration _anchor = anchor == null ? this.getFirstChild() : anchor;
        CssDeclaration result = (CssDeclaration)this.addAfter((PsiElement)cssDeclaration, (PsiElement)_anchor);
        this.addAfter(newLine, (PsiElement)_anchor);
        return result;
    }

    public void removeDeclaration(@NotNull CssDeclaration declaration) throws IncorrectOperationException {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/plugins/sass/psi/impl/SASSDeclarationBlockImpl", "removeDeclaration"));
        }
        assert (declaration.getParent() == this);
        PsiElement nextSibling = declaration.getNextSibling();
        if (nextSibling != null && TokenSet.create((IElementType[])new IElementType[]{SASSTokenTypes.EOL, TokenType.WHITE_SPACE}).contains(nextSibling.getNode().getElementType())) {
            nextSibling.delete();
        }
        declaration.delete();
    }

    @Nullable
    public CssDeclaration findDeclaration(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/plugins/sass/psi/impl/SASSDeclarationBlockImpl", "findDeclaration"));
        }
        return this.findDeclaration(propertyName, true);
    }

    @Nullable
    public CssDeclaration findDeclaration(@NotNull String propertyName, boolean searchInShorthand) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/plugins/sass/psi/impl/SASSDeclarationBlockImpl", "findDeclaration"));
        }
        return CssPsiUtil.findDeclaration((CssBlock)this, (String)propertyName, (boolean)searchInShorthand);
    }
}

