/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions.compass;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSBundle;
import org.jetbrains.plugins.sass.extensions.SassRubyIntegrationHelper;

@State(name="CompassSettings")
public class CompassSettings
implements PersistentStateComponent<CompassSettings> {
    @NotNull
    private Module myModule;
    @NotNull
    private ThreeState myCompassSupportEnabled;
    @Nullable
    private String myCompassExecutableFilePath;
    @Nullable
    private String myCompassConfigPath;
    @NotNull
    private List<String> myImportPaths;

    public static CompassSettings getInstance(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/compass/CompassSettings", "getInstance"));
        }
        return !module.isDisposed() ? (CompassSettings)ModuleServiceManager.getService((Module)module, CompassSettings.class) : null;
    }

    public void loadState(@NotNull CompassSettings state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/sass/extensions/compass/CompassSettings", "loadState"));
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public CompassSettings() {
        this.myCompassSupportEnabled = ThreeState.UNSURE;
        this.myCompassExecutableFilePath = null;
        this.myCompassConfigPath = null;
        this.myImportPaths = ContainerUtil.newArrayList();
    }

    public CompassSettings(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/compass/CompassSettings", "<init>"));
        }
        this.myCompassSupportEnabled = ThreeState.UNSURE;
        this.myCompassExecutableFilePath = null;
        this.myCompassConfigPath = null;
        this.myImportPaths = ContainerUtil.newArrayList();
        this.myModule = module;
    }

    public boolean isCompassSupportEnabled() {
        return this.myCompassSupportEnabled == ThreeState.YES || this.myCompassSupportEnabled == ThreeState.UNSURE && this.myModule != null && SassRubyIntegrationHelper.getInstance().isGemInstalled(SASSBundle.message("compass.gem.name"), this.myModule);
    }

    public void setCompassSupportEnabled(boolean compassSupportEnabled) {
        this.myCompassSupportEnabled = compassSupportEnabled ? ThreeState.YES : ThreeState.NO;
    }

    public void resetEnabledFlag() {
        this.myCompassSupportEnabled = ThreeState.UNSURE;
    }

    @NotNull
    public String getCompassExecutableFilePath() {
        String string = StringUtil.notNullize((String)this.myCompassExecutableFilePath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/compass/CompassSettings", "getCompassExecutableFilePath"));
        }
        return string;
    }

    public void setCompassExecutableFilePath(@Nullable String compassExecutablePath) {
        this.myCompassExecutableFilePath = compassExecutablePath;
    }

    @NotNull
    public String getCompassConfigPath() {
        String string = StringUtil.notNullize((String)this.myCompassConfigPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/compass/CompassSettings", "getCompassConfigPath"));
        }
        return string;
    }

    public void setCompassConfigPath(@Nullable String compassConfigPath) {
        this.myCompassConfigPath = compassConfigPath;
    }

    @Nullable
    public CompassSettings getState() {
        return this;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/compass/CompassSettings", "getModule"));
        }
        return module;
    }

    @NotNull
    public List<String> getImportPaths() {
        List<String> list = this.myImportPaths;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/compass/CompassSettings", "getImportPaths"));
        }
        return list;
    }

    public void setImportPaths(@NotNull List<String> importPaths) {
        if (importPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importPaths", "org/jetbrains/plugins/sass/extensions/compass/CompassSettings", "setImportPaths"));
        }
        this.myImportPaths = importPaths;
    }
}

