/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions.compass;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.Disposer;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSBundle;
import org.jetbrains.plugins.sass.extensions.compass.CompassSassExtension;
import org.jetbrains.plugins.sass.extensions.compass.CompassSettings;
import org.jetbrains.plugins.sass.extensions.compass.CompassSettingsPanel;
import org.jetbrains.plugins.sass.extensions.compass.CompassSettingsPanelImpl;
import org.jetbrains.plugins.sass.extensions.compass.CompassUtil;

public class CompassConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @Nullable
    private final Module myModule;
    @Nullable
    private final CompassSassExtension myCompassSassExtension;
    private final boolean myFullMode;
    @Nullable
    private final CompassSettings myCompassSettings;
    @Nullable
    private CompassSettingsPanel myPanel;

    public CompassConfigurable(@Nullable Module module, @Nullable CompassSassExtension compassSassExtension, boolean fullMode) {
        this.myModule = module;
        this.myCompassSassExtension = compassSassExtension;
        this.myFullMode = fullMode;
        this.myCompassSettings = module != null ? CompassSettings.getInstance(module) : null;
    }

    @NotNull
    public String getId() {
        String string = SASSBundle.message("compass.support.id");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/compass/CompassConfigurable", "getId"));
        }
        return string;
    }

    @Nls
    public String getDisplayName() {
        return SASSBundle.message("compass.support.configurable.name");
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settings.project.settings.compass.support";
    }

    @Nullable
    public JComponent createComponent() {
        if (this.myPanel == null && this.myModule != null && this.myCompassSettings != null) {
            this.myPanel = this.createCompassSettingsPanel(this.myModule, this.myFullMode);
        }
        return this.myPanel != null ? this.myPanel.getComponent() : null;
    }

    public boolean isModified() {
        return this.myPanel != null && this.myPanel.isModified(this.myCompassSettings);
    }

    public void apply() throws ConfigurationException {
        if (this.myPanel != null) {
            boolean executablePathChanged = this.myPanel.isExecutablePathChanged(this.myCompassSettings);
            boolean enableOptionChanged = this.myPanel.isEnableOptionChanged(this.myCompassSettings);
            boolean configPathChanged = this.myPanel.isConfigFilePathChanged(this.myCompassSettings);
            this.myPanel.apply(this.myCompassSettings);
            if (this.myModule != null && this.myCompassSettings != null) {
                if (!this.myCompassSettings.isCompassSupportEnabled()) {
                    CompassUtil.removeCompassLibraryIfNeeded(this.myModule);
                }
                if ((enableOptionChanged || configPathChanged || executablePathChanged) && this.myCompassSassExtension != null) {
                    this.myCompassSassExtension.stopActivity(this.myModule);
                    this.myCompassSettings.setImportPaths(Collections.emptyList());
                    if (this.myCompassSassExtension.isAvailableInModule(this.myModule)) {
                        this.myCompassSassExtension.startActivity(this.myModule);
                    }
                }
            }
        }
    }

    @NotNull
    protected CompassSettingsPanel createCompassSettingsPanel(@NotNull Module module, boolean fullMode) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/compass/CompassConfigurable", "createCompassSettingsPanel"));
        }
        List<String> variants = ApplicationManager.getApplication().isUnitTestMode() ? Collections.emptyList() : CompassUtil.getExecutableFilesVariants();
        CompassSettingsPanelImpl compassSettingsPanelImpl = new CompassSettingsPanelImpl(module, variants, CompassUtil.getConfigFileVariants(module), fullMode);
        if (compassSettingsPanelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/compass/CompassConfigurable", "createCompassSettingsPanel"));
        }
        return compassSettingsPanelImpl;
    }

    public void reset() {
        if (this.myPanel != null) {
            this.myPanel.reset(this.myCompassSettings);
        }
    }

    public void disposeUIResources() {
        if (this.myPanel != null) {
            Disposer.dispose((Disposable)this.myPanel);
        }
        this.myPanel = null;
    }
}

