/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions.compass;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.extensions.compass.CompassConfig;

public abstract class CompassConfigParser {
    protected static final String ADD_IMPORT_PATH_CALL = "add_import_path";
    protected static final String ADDITIONAL_IMPORT_PATHS_ASSIGNMENT = "additional_import_paths";

    @NotNull
    public final CompassConfig parse(@NotNull VirtualFile file, @Nullable PsiManager psiManager) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/sass/extensions/compass/CompassConfigParser", "parse"));
        }
        VirtualFile parentFile = file.getParent();
        String parentPath = parentFile != null ? parentFile.getPath() : "";
        CompassConfig compassConfig = this.parse(file, parentPath, psiManager);
        if (compassConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/compass/CompassConfigParser", "parse"));
        }
        return compassConfig;
    }

    @NotNull
    public abstract CompassConfig parse(@NotNull VirtualFile var1, @NotNull String var2, @Nullable PsiManager var3);

    protected static String normalizePath(@NotNull String path, @NotNull String configParentPath) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/sass/extensions/compass/CompassConfigParser", "normalizePath"));
        }
        if (configParentPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configParentPath", "org/jetbrains/plugins/sass/extensions/compass/CompassConfigParser", "normalizePath"));
        }
        return FileUtil.isAbsolutePlatformIndependent((String)path) ? path : FileUtil.toCanonicalPath((String)FileUtil.join((String[])new String[]{configParentPath, path}));
    }
}

