/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.editor;

import com.intellij.lang.BracePair;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.editor.CssBraceMatcher;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.psi.SASSTokenTypes;
import org.jetbrains.plugins.scss.lexer.SCSSTokenTypes;

public class SassScssBraceMatcher
extends CssBraceMatcher {
    private static final BracePair[] BRACE_PAIRS = new BracePair[]{new BracePair(CssElementTypes.CSS_LPAREN, CssElementTypes.CSS_RPAREN, false), new BracePair(CssElementTypes.CSS_LBRACKET, CssElementTypes.CSS_RBRACKET, false), new BracePair(CssElementTypes.CSS_LBRACE, CssElementTypes.CSS_RBRACE, true), new BracePair(SCSSTokenTypes.INTERPOLATION_PREFIX, SCSSTokenTypes.INTERPOLATION_SUFFIX, true)};

    public BracePair[] getPairs() {
        return BRACE_PAIRS;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType type) {
        if (lbraceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lbraceType", "org/jetbrains/plugins/sass/editor/SassScssBraceMatcher", "isPairedBracesAllowedBeforeType"));
        }
        return super.isPairedBracesAllowedBeforeType(lbraceType, type) || SASSTokenTypes.COMMENTS.contains(type) || SCSSTokenTypes.COMMENTS.contains(type) || SASSTokenTypes.WHITESPACE_TOKENS.contains(type) || SCSSTokenTypes.INTERPOLATION_SUFFIX == type;
    }

    public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
        return openingBraceOffset;
    }
}

