/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.completion.SassScssCompletionContributor;
import org.jetbrains.plugins.scss.SASSSCSSLangUtil;
import org.jetbrains.plugins.scss.psi.SassScssInclude;
import org.jetbrains.plugins.scss.psi.SassScssVariableDeclaration;
import org.jetbrains.plugins.scss.psi.stubs.ScssVariablesIndex;

public class VariableNamesProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/sass/completion/VariableNamesProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/sass/completion/VariableNamesProvider", "addCompletions"));
        }
        PsiElement originalElement = parameters.getOriginalPosition();
        PsiFile originalFile = parameters.getOriginalFile();
        PsiElement position = parameters.getPosition();
        Project project = parameters.getPosition().getProject();
        String prefix = result.getPrefixMatcher().getPrefix();
        SassScssVariableDeclaration originalParentDeclaration = (SassScssVariableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)originalElement, SassScssVariableDeclaration.class);
        Set importedFiles = CssUtil.getImportedFiles((PsiFile)originalFile, (PsiElement)position, (boolean)false);
        PsiElement parent = position.getParent();
        SassScssInclude parentInclude = (SassScssInclude)PsiTreeUtil.getParentOfType((PsiElement)position, SassScssInclude.class);
        SassScssInclude originalParentInclude = parentInclude != null ? (SassScssInclude)CompletionUtil.getOriginalElement((PsiElement)parentInclude) : null;
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)position);
        for (String name : StubIndex.getInstance().getAllKeys(ScssVariablesIndex.KEY, project)) {
            ScssVariablesIndex.process(name, project, scope, (Processor<? super SassScssVariableDeclaration>)((Processor)declaration -> {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/sass/completion/VariableNamesProvider", "lambda$addCompletions$0"));
                }
                if (originalParentDeclaration == declaration || parent == declaration) {
                    return true;
                }
                if (originalParentInclude != null && PsiTreeUtil.getParentOfType((PsiElement)declaration, SassScssInclude.class) == originalParentInclude) {
                    return true;
                }
                if (declaration != null && SASSSCSSLangUtil.isVisibleDeclaration((PsiElement)declaration, position)) {
                    boolean validResult = importedFiles.contains(declaration.getContainingFile().getVirtualFile());
                    result.addElement(SASSSCSSLangUtil.createVariableLookupItem(declaration, validResult, prefix));
                }
                return true;
            }));
            result.restartCompletionOnPrefixChange(SassScssCompletionContributor.RESTART_IDENTIFIER_COMPLETION_CONDITION);
        }
    }
}

