/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.scss.psi.SassScssAtRootQueryValue;

public class AtRootQueryValueProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/sass/completion/AtRootQueryValueProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/sass/completion/AtRootQueryValueProvider", "addCompletions"));
        }
        PsiElement queryValue = PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), SassScssAtRootQueryValue.class);
        HashSet usedValues = queryValue != null ? ContainerUtil.newHashSet((Iterable)StringUtil.split((String)queryValue.getText(), (String)" ")) : Collections.emptySet();
        AtRootQueryValueProvider.addElement("all", usedValues, result);
        PsiElement ruleset = PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), CssRuleset.class, (boolean)false);
        if (ruleset != null) {
            AtRootQueryValueProvider.addElement("rule", usedValues, result);
        }
        CssAtRule atRule = (CssAtRule)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), CssAtRule.class, (boolean)false);
        while (atRule != null) {
            String ruleName = StringUtil.trimLeading((String)atRule.getName(), (char)'@');
            if (!ruleName.isEmpty() && !"at-root".equalsIgnoreCase(ruleName)) {
                AtRootQueryValueProvider.addElement(ruleName, usedValues, result);
            }
            atRule = (CssAtRule)PsiTreeUtil.getParentOfType((PsiElement)atRule, CssAtRule.class);
        }
        result.stopHere();
    }

    private static void addElement(@NotNull String ruleName, @NotNull Set<String> usedValues, @NotNull CompletionResultSet result) {
        if (ruleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ruleName", "org/jetbrains/plugins/sass/completion/AtRootQueryValueProvider", "addElement"));
        }
        if (usedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usedValues", "org/jetbrains/plugins/sass/completion/AtRootQueryValueProvider", "addElement"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/sass/completion/AtRootQueryValueProvider", "addElement"));
        }
        if (!usedValues.contains(ruleName)) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)ruleName).withIcon(AllIcons.Css.Atrule));
        }
    }
}

