/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud.view;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3ApplicationPropertyImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.remoteServer.util.Column;
import com.intellij.remoteServer.util.JTableWrapper;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import java.awt.Dimension;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;

public class OS3PropertiesEditor {
    private final JTableWrapper<OS3ApplicationPropertyImpl, ColumnBase> myTableWrapper;
    private final JPanel myPanel;
    private List<OS3ApplicationPropertyImpl> myItems;

    public OS3PropertiesEditor() {
        JBTable table = new JBTable();
        this.myTableWrapper = new JTableWrapper(table, (Column[])new ColumnBase[]{new NameColumn(), new ValueColumn()});
        this.myPanel = ToolbarDecorator.createDecorator((JTable)table).addExtraAction((AnActionButton)new CopyAction()).createPanel();
        this.myPanel.setPreferredSize(new Dimension(-1, 200));
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    private void update() {
        this.myTableWrapper.setInputRows(this.myItems);
    }

    public void setItems(List<OS3ApplicationPropertyImpl> items) {
        this.myItems = new ArrayList<OS3ApplicationPropertyImpl>(items);
        this.update();
    }

    private class CopyAction
    extends AnActionButton {
        public CopyAction() {
            super("Copy selection to clipboard", AllIcons.Actions.Copy);
        }

        public void actionPerformed(AnActionEvent e) {
            int selectedRow = OS3PropertiesEditor.this.myTableWrapper.getTable().getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            int selectedColumn = OS3PropertiesEditor.this.myTableWrapper.getTable().getSelectedColumn();
            if (selectedColumn == -1) {
                return;
            }
            OS3ApplicationPropertyImpl property = (OS3ApplicationPropertyImpl)OS3PropertiesEditor.this.myItems.get(selectedRow);
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(selectedColumn == 0 ? property.getName() : property.getValue()));
        }
    }

    private static class ValueColumn
    extends ColumnBase {
        public ValueColumn() {
            super("Value");
        }

        public Object getColumnValue(OS3ApplicationPropertyImpl row) {
            return row.getValue();
        }
    }

    private static class NameColumn
    extends ColumnBase {
        public NameColumn() {
            super("Name");
        }

        public Object getColumnValue(OS3ApplicationPropertyImpl row) {
            return row.getName();
        }
    }

    public static abstract class ColumnBase
    extends Column<OS3ApplicationPropertyImpl> {
        public ColumnBase(String name) {
            super(name);
        }
    }
}

