/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3TemplateParameterDefinitionImpl;
import com.intellij.javaee.openshift.cloud.OSBundle;
import com.intellij.javaee.openshift.cloud.OSCloudConfiguration;
import com.intellij.javaee.openshift.cloud.OSDeploymentDetector;
import com.intellij.javaee.openshift.cloud.OSServerRuntimeInstance;
import com.intellij.javaee.openshift.cloud.deploymentSource.OS3LocalTemplateDeploymentSource;
import com.intellij.javaee.openshift.cloud.deploymentSource.OS3ServerTemplateDeploymentSource;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.util.RepositoryDeploymentConfiguration;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudDeploymentNameProvider;
import com.intellij.remoteServer.util.CloudGitDeploymentChecker;
import com.intellij.remoteServer.util.CloudGitDeploymentDetector;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OSDeploymentConfiguration
extends CloudDeploymentNameConfiguration<OSDeploymentConfiguration>
implements RepositoryDeploymentConfiguration {
    public static final String OS3_VERSION_WARNING = OSBundle.getText("OSDeploymentConfiguration.os.version.warning", new Object[0]);
    public static final CloudDeploymentNameProvider DEPLOYMENT_NAME_PROVIDER = new CloudDeploymentNameProvider(){

        @NotNull
        public String getDeploymentName(@NotNull DeploymentSource deploymentSource) {
            if (deploymentSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentSource", "com/intellij/javaee/openshift/cloud/OSDeploymentConfiguration$1", "getDeploymentName"));
            }
            String string = CloudDeploymentNameProvider.DEFAULT_NAME_PROVIDER.getDeploymentName(deploymentSource).replace("_", "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/openshift/cloud/OSDeploymentConfiguration$1", "getDeploymentName"));
            }
            return string;
        }
    };
    private static final CloudGitDeploymentChecker<OSDeploymentConfiguration, OSCloudConfiguration, OSServerRuntimeInstance> ourCloudGitDeploymentChecker = new CloudGitDeploymentChecker((CloudGitDeploymentDetector)new OSDeploymentDetector());
    private String myRepositoryPath;
    private Integer myDebugPort;
    private String myProjectName;
    private String myTemplateName;
    private List<OS3TemplateParameterDefinitionImpl> myTemplateParameters = new ArrayList<OS3TemplateParameterDefinitionImpl>();

    public String getRepositoryPath() {
        return this.myRepositoryPath;
    }

    public void setRepositoryPath(String repositoryPath) {
        this.myRepositoryPath = repositoryPath;
    }

    public Integer getDebugPort() {
        return this.myDebugPort;
    }

    public void setDebugPort(Integer debugPort) {
        this.myDebugPort = debugPort;
    }

    protected String getDefaultDeploymentSourceName(DeploymentSource deploymentSource) {
        return DEPLOYMENT_NAME_PROVIDER.getDeploymentName(deploymentSource);
    }

    public void checkConfiguration(RemoteServer<?> server, DeploymentSource deploymentSource) throws RuntimeConfigurationException {
        boolean isOS3DeploymentSource;
        RemoteServer<?> remoteServer = server;
        boolean isOS3Server = ((OSCloudConfiguration)remoteServer.getConfiguration()).isOS3();
        boolean bl = isOS3DeploymentSource = deploymentSource instanceof OS3LocalTemplateDeploymentSource || deploymentSource instanceof OS3ServerTemplateDeploymentSource;
        if (isOS3Server ^ isOS3DeploymentSource) {
            throw new RuntimeConfigurationError(OS3_VERSION_WARNING);
        }
        if (!isOS3Server) {
            ourCloudGitDeploymentChecker.checkGitUrl(remoteServer, deploymentSource, (CloudDeploymentNameConfiguration)this);
        }
    }

    public String getProjectName() {
        return this.myProjectName;
    }

    public void setProjectName(String projectName) {
        this.myProjectName = projectName;
    }

    public List<OS3TemplateParameterDefinitionImpl> getTemplateParameters() {
        return this.myTemplateParameters;
    }

    public void setTemplateParameters(List<OS3TemplateParameterDefinitionImpl> templateParameters) {
        this.myTemplateParameters = templateParameters;
    }

    public String getTemplateName() {
        return this.myTemplateName;
    }

    public void setTemplateName(String templateName) {
        this.myTemplateName = templateName;
    }
}

