/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.javaee.openshift.cloud.OS3JsonTemplate;
import com.intellij.javaee.openshift.cloud.OSCloudType;
import com.intellij.javaee.openshift.cloud.deploymentSource.OS3LocalTemplateDeploymentSource;
import com.intellij.javaee.openshift.cloud.deploymentSource.OS3ServerTemplateDeploymentSourceType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudDeploymentRuntime;
import com.intellij.remoteServer.util.CloudDeploymentRuntimeProvider;
import com.intellij.remoteServer.util.CloudModuleDeploymentRuntimeProviderBase;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class OS3TemplateRuntimeProvider
implements CloudDeploymentRuntimeProvider {
    private static final Logger LOG = Logger.getInstance((String)("#" + CloudModuleDeploymentRuntimeProviderBase.class.getName()));
    private static final String TEMPLATE_EXT = "json";

    public ServerType<?> getServerType() {
        return OSCloudType.getInstance();
    }

    public Collection<DeploymentSource> getDeploymentSources(Project project) {
        ArrayList<DeploymentSource> result = new ArrayList<DeploymentSource>();
        result.addAll(ContainerUtil.map(OS3TemplateRuntimeProvider.getLocalTemplateFiles(project), file -> new OS3LocalTemplateDeploymentSource(project, (File)file)));
        result.add(OS3ServerTemplateDeploymentSourceType.getInstance().getDeploymentSource());
        return result;
    }

    public CloudDeploymentRuntime createDeploymentRuntime(DeploymentSource source, CloudMultiSourceServerRuntimeInstance serverRuntime, DeploymentTask<? extends CloudDeploymentNameConfiguration> deploymentTask, DeploymentLogManager logManager) throws ServerRuntimeException {
        throw new UnsupportedOperationException();
    }

    public static Collection<File> getLocalTemplateFiles(Project project) {
        return (Collection)ApplicationManager.getApplication().runReadAction(() -> {
            Collection jsonFiles = FilenameIndex.getAllFilesByExt((Project)project, (String)TEMPLATE_EXT);
            ArrayList result = new ArrayList();
            jsonFiles.stream().filter(jsonFile -> jsonFile != null).forEach(jsonFile -> {
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    OS3JsonTemplate template = (OS3JsonTemplate)objectMapper.readValue(jsonFile.getInputStream(), OS3JsonTemplate.class);
                    if (StringUtil.equals((CharSequence)template.getKind(), (CharSequence)"Template")) {
                        result.add(VfsUtilCore.virtualToIoFile((VirtualFile)jsonFile));
                    }
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            });
            return result;
        });
    }
}

