/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.intellij.javaee.openshift.agent.cloud.os3.OS3Template;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3TemplateParameterDefinitionImpl;
import com.intellij.javaee.openshift.cloud.OS3ServerRuntimeInstance;
import com.intellij.javaee.openshift.cloud.OSCloudConfiguration;
import com.intellij.javaee.openshift.cloud.OSDeploymentConfiguration;
import com.intellij.javaee.openshift.cloud.TemplateDeploymentEditorBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OS3ServerTemplateDeploymentEditor
extends TemplateDeploymentEditorBase {
    private JPanel myPanel;
    private JComboBox<String> myProjectsComboBox;
    private JComboBox<String> myTemplatesComboBox;
    private JPanel myTemplateParametersPlaceHolder;
    private JPanel myErrorMessagePlaceholder;
    private boolean myTemplatesLoaded = false;
    private String myStoredTemplateName;
    private List<OS3TemplateParameterDefinitionImpl> myStoredTemplateParameters;
    private List<OS3Template> myServerTemplates;

    public OS3ServerTemplateDeploymentEditor(RemoteServer<OSCloudConfiguration> server) {
        this.$$$setupUI$$$();
        this.setupComponents();
        this.myTemplatesComboBox.setEnabled(false);
        this.myTemplatesComboBox.addItem(this.getLoadingText());
        this.myTemplatesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OS3ServerTemplateDeploymentEditor.this.myTemplatesComboBox.getSelectedItem() == null) {
                    return;
                }
                OS3Template template = OS3ServerTemplateDeploymentEditor.this.findTemplateByName(OS3ServerTemplateDeploymentEditor.this.myTemplatesComboBox.getSelectedItem().toString());
                if (template == null) {
                    return;
                }
                boolean isStoredParameters = StringUtil.equals((CharSequence)OS3ServerTemplateDeploymentEditor.this.myStoredTemplateName, (CharSequence)template.getApplicationName());
                OS3ServerTemplateDeploymentEditor.this.setTemplateParameters(isStoredParameters ? OS3ServerTemplateDeploymentEditor.this.myStoredTemplateParameters : Arrays.asList(template.getParameters()));
            }
        });
        this.loadServerData(server);
    }

    @Override
    protected void doLoadServerData(OS3ServerRuntimeInstance os3ServerRuntimeInstance) throws ServerRuntimeException {
        super.doLoadServerData(os3ServerRuntimeInstance);
        this.loadServerTemplates(os3ServerRuntimeInstance);
    }

    private void loadServerTemplates(OS3ServerRuntimeInstance os3ServerRuntimeInstance) throws ServerRuntimeException {
        this.myServerTemplates = os3ServerRuntimeInstance.getServerTemplates();
        ApplicationManager.getApplication().invokeLater(() -> {
            OS3Template template2;
            this.myTemplatesComboBox.removeAllItems();
            this.myServerTemplates.forEach(template -> this.myTemplatesComboBox.addItem(template.getApplicationName()));
            this.myTemplatesLoaded = true;
            this.updateLoadingState();
            if (!StringUtil.isEmpty((String)this.myStoredTemplateName) && (template2 = this.findTemplateByName(this.myStoredTemplateName)) != null) {
                this.myTemplatesComboBox.setSelectedItem(template2.getApplicationName());
            }
        }, ModalityState.any());
    }

    @Override
    protected void updateLoadingState() {
        if (this.myTemplatesLoaded && this.areProjectsLoaded()) {
            this.myProjectsComboBox.setEnabled(true);
            this.myTemplatesComboBox.setEnabled(true);
        }
    }

    protected void resetEditorFrom(@NotNull OSDeploymentConfiguration s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/javaee/openshift/cloud/OS3ServerTemplateDeploymentEditor", "resetEditorFrom"));
        }
        this.setStoredProjectName(s.getProjectName());
        this.myStoredTemplateName = s.getTemplateName();
        this.myStoredTemplateParameters = s.getTemplateParameters();
        this.setTemplateParameters(s.getTemplateParameters());
    }

    protected void applyEditorTo(@NotNull OSDeploymentConfiguration s) throws ConfigurationException {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/javaee/openshift/cloud/OS3ServerTemplateDeploymentEditor", "applyEditorTo"));
        }
        this.checkRequiredParameters();
        String projectName = this.getSelectedItem(this.myProjectsComboBox, "Project");
        String templateName = this.getSelectedItem(this.myTemplatesComboBox, "Template");
        s.setProjectName(projectName);
        s.setTemplateName(templateName);
        s.setTemplateParameters(this.getTemplateParameters());
    }

    @Nullable
    private OS3Template findTemplateByName(String selectedTemplateName) {
        return (OS3Template)ContainerUtil.find(this.myServerTemplates, serverTemplate -> StringUtil.equals((CharSequence)serverTemplate.getApplicationName(), (CharSequence)selectedTemplateName));
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/openshift/cloud/OS3ServerTemplateDeploymentEditor", "createEditor"));
        }
        return jPanel;
    }

    @Override
    protected JComboBox<String> getProjectsComboBox() {
        return this.myProjectsComboBox;
    }

    @Override
    protected JPanel getErrorMessagePlaceholder() {
        return this.myErrorMessagePlaceholder;
    }

    @Override
    protected JPanel getTemplateParametersEditorPlaceHolder() {
        return this.myTemplateParametersPlaceHolder;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        ComboBox comboBox;
        ComboBox comboBox2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel3).setEnabled(false);
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Projects:");
        jBLabel.setDisplayedMnemonic('P');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(80, 16), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Templates:");
        jBLabel2.setDisplayedMnemonic('T');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(80, 16), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 3, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 2, 1, 0, 3, 7, 0, null, null, null));
        this.myProjectsComboBox = comboBox2 = new ComboBox();
        comboBox2.setEditable(false);
        comboBox2.setEnabled(true);
        jPanel4.add((Component)comboBox2, new GridConstraints(0, 0, 1, 1, 8, 1, 7, 7, null, null, null));
        this.myTemplatesComboBox = comboBox = new ComboBox();
        jPanel4.add((Component)comboBox, new GridConstraints(1, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myTemplateParametersPlaceHolder = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myErrorMessagePlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        ((Component)jPanel).setEnabled(false);
        ((Component)jPanel).setVisible(false);
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Parameters:");
        jPanel3.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor((Component)comboBox2);
        jBLabel2.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

