/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.LineSeparator;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.editorconfig.configmanagement.EncodingManager;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.plugincomponents.EditorConfigNotifier;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;

public class Utils {
    public static String configValueForKey(List<EditorConfig.OutPair> outPairs, String key) {
        for (EditorConfig.OutPair outPair : outPairs) {
            if (!outPair.getKey().equals(key)) continue;
            return outPair.getVal();
        }
        return "";
    }

    public static boolean isEnabled(CodeStyleSettings currentSettings) {
        return currentSettings != null && ((EditorConfigSettings)currentSettings.getCustomSettings(EditorConfigSettings.class)).ENABLED;
    }

    public static void invalidConfigMessage(Project project, String configValue, String configKey, String filePath) {
        String message = configValue != null ? "\"" + configValue + "\" is not a valid value" + (!configKey.isEmpty() ? " for " + configKey : "") + " for file " + filePath : "Failed to read .editorconfig file";
        configValue = configValue != null ? configValue : "ioError";
        EditorConfigNotifier.getInstance().error(project, configValue, message);
    }

    public static String getFilePath(Project project, VirtualFile file) {
        if (!file.isInLocalFileSystem()) {
            return project.getBasePath() + "/" + file.getNameWithoutExtension() + "." + file.getFileType().getDefaultExtension();
        }
        return file.getCanonicalPath();
    }

    public static void export(Project project) {
        String message;
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project);
        CommonCodeStyleSettings.IndentOptions commonIndentOptions = settings.getIndentOptions();
        StringBuilder result = new StringBuilder();
        Utils.addIndentOptions(result, "*", commonIndentOptions, Utils.getEncoding(project) + Utils.getLineEndings(project) + Utils.getTrailingSpaces() + Utils.getEndOfFile());
        for (FileType fileType : FileTypeManager.getInstance().getRegisteredFileTypes()) {
            CommonCodeStyleSettings.IndentOptions options;
            if (!FileTypeIndex.containsFileOfType((FileType)fileType, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project)) || Utils.equalIndents(commonIndentOptions, options = settings.getIndentOptions(fileType))) continue;
            Utils.addIndentOptions(result, Utils.buildPattern(fileType), options, "");
        }
        VirtualFile baseDir = project.getBaseDir();
        VirtualFile child = baseDir.findChild(".editorconfig");
        if (child != null && Messages.showYesNoDialog((Project)project, (String)(message = ".editorconfig already present in " + baseDir.getPath() + "\nOverwrite?"), (String)".editorconfig exists", null) == 1) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                VirtualFile editorConfig = baseDir.findOrCreateChildData(Utils.class, ".editorconfig");
                VfsUtil.saveText((VirtualFile)editorConfig, (String)result.toString());
            }
            catch (IOException e) {
                Logger.getInstance(Utils.class).error((Throwable)e);
            }
        });
    }

    private static String getEndOfFile() {
        return "insert_final_newline=" + EditorSettingsExternalizable.getInstance().isEnsureNewLineAtEOF() + "\n";
    }

    private static String getTrailingSpaces() {
        String spaces = EditorSettingsExternalizable.getInstance().getStripTrailingSpaces();
        if ("None".equals(spaces)) {
            return "trim_trailing_whitespace=false\n";
        }
        if ("Whole".equals(spaces)) {
            return "trim_trailing_whitespace=true\n";
        }
        return "";
    }

    private static String getLineEndings(Project project) {
        String separator = CodeStyleFacade.getInstance((Project)project).getLineSeparator();
        for (LineSeparator s : LineSeparator.values()) {
            if (!separator.equals(s.getSeparatorString())) continue;
            return "end_of_line=" + s.name().toLowerCase(Locale.US) + "\n";
        }
        return "";
    }

    @NotNull
    private static String getEncoding(Project project) {
        Charset charset = EncodingProjectManager.getInstance((Project)project).getDefaultCharset();
        for (Map.Entry<String, Charset> entry : EncodingManager.encodingMap.entrySet()) {
            if (entry.getValue() != charset) continue;
            String string = "charset=" + entry.getKey() + "\n";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/editorconfig/Utils", "getEncoding"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/editorconfig/Utils", "getEncoding"));
        }
        return "";
    }

    @NotNull
    private static String buildPattern(FileType fileType) {
        StringBuilder result = new StringBuilder();
        List associations = FileTypeManager.getInstance().getAssociations(fileType);
        for (FileNameMatcher matcher : associations) {
            if (result.length() != 0) {
                result.append(",");
            }
            result.append(matcher.getPresentableString());
        }
        if (associations.size() > 1) {
            result.insert(0, "{").append("}");
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/editorconfig/Utils", "buildPattern"));
        }
        return string;
    }

    private static boolean equalIndents(CommonCodeStyleSettings.IndentOptions commonIndentOptions, CommonCodeStyleSettings.IndentOptions options) {
        return options.USE_TAB_CHARACTER == commonIndentOptions.USE_TAB_CHARACTER && options.TAB_SIZE == commonIndentOptions.TAB_SIZE && options.INDENT_SIZE == commonIndentOptions.INDENT_SIZE;
    }

    private static void addIndentOptions(StringBuilder result, String pattern, CommonCodeStyleSettings.IndentOptions options, String additionalText) {
        if (pattern.isEmpty()) {
            return;
        }
        result.append("[").append(pattern).append("]").append("\n");
        result.append(additionalText);
        result.append("indent_style").append("=");
        if (options.USE_TAB_CHARACTER) {
            result.append("tab\n");
            result.append("tab_width").append("=").append(options.TAB_SIZE).append("\n");
        } else {
            result.append("space\n");
            result.append("indent_size").append("=").append(options.INDENT_SIZE).append("\n");
        }
        result.append("\n");
    }
}

