/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.maven;

import com.intellij.flex.maven.IdeaConfigurator;
import com.intellij.flex.maven.Utils;
import java.io.File;
import java.io.IOException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;

public class ShareableFlexConfigGenerator
extends IdeaConfigurator {
    private static final String TARGET_WITH_FRONT_SLASH = "/target";
    private static final String CLASSSES_WITH_FRONT_SLASH = "/target/classes";
    private static boolean listForGantGenerated;
    private String localRepositoryBasedir;
    private int localRepositoryBasedirLength;
    private String baseDir;

    public ShareableFlexConfigGenerator(MavenSession session, File outputDirectory) {
        super(session, new File("build-gant/flex-configs"));
        this.outputDirectory.mkdirs();
    }

    @Override
    public void preGenerate(MavenProject project, String classifier) throws IOException {
        super.preGenerate(project, classifier);
        this.baseDir = project.getBasedir().getPath();
        this.localRepositoryBasedir = this.session.getLocalRepository().getBasedir();
        this.localRepositoryBasedirLength = this.localRepositoryBasedir.length();
        if (!listForGantGenerated) {
            listForGantGenerated = true;
            StringBuilder s = new StringBuilder(8192);
            s.append("def List<SwfDescriptor> getList() {\n\treturn [");
            boolean isFirst = true;
            int absPathPrefixLength = this.session.getTopLevelProject().getBasedir().getPath().length();
            for (MavenProject p : this.session.getProjects()) {
                String packaging = p.getPackaging();
                if (!packaging.equals("swf") && !packaging.equals("air") && !packaging.equals("swc")) continue;
                if (!isFirst) {
                    s.append(", ");
                } else {
                    isFirst = false;
                }
                s.append("\n\t\tnew SwfDescriptor(\"").append(p.getArtifactId()).append(".xml\", \"");
                String pBaseDir = p.getBasedir().getPath();
                if (this.session.getTopLevelProject() != p) {
                    s.append(pBaseDir.substring(absPathPrefixLength + 1));
                } else {
                    s.append(pBaseDir);
                }
                s.append("\", ").append(packaging.equals("swc") ? "true" : "false").append(')');
            }
            s.append("\n\t];\n}");
            Utils.write((StringBuilder)s, (File)new File("build-gant/flex_ui_designer_swfs_build.gant"));
        }
    }

    @Override
    protected String getConfigFilePath(MavenProject project, String classifier) {
        return project.getArtifactId() + ".xml";
    }

    @Override
    protected void processValue(String value, String name) throws IOException {
        if (name.equals("local-fonts-snapshot")) {
            this.out.append("@@repo@@/fonts.ser");
        } else if (name.equals("output")) {
            this.target(value);
        } else {
            super.processValue(value, name);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void writeTag(String indent, String name, String value, String parentName) throws IOException {
        if (name.equals("path-element") || name.equals("library") || name.equals("manifest") || name.equals("path")) {
            this.out.append(indent).append("\t<").append(name).append('>');
            if (parentName.equals("file-specs") || parentName.equals("source-path") || parentName.equals("include-sources") || parentName.equals("include-file")) {
                if (value.startsWith(this.baseDir)) {
                    this.out.append("@@baseDir@@").append(value, this.baseDir.length(), value.length());
                } else {
                    int sIndex = value.indexOf(TARGET_WITH_FRONT_SLASH);
                    if (sIndex == -1) throw new IllegalArgumentException(value);
                    this.out.append("@@target@@").append(value, sIndex + TARGET_WITH_FRONT_SLASH.length(), value.length());
                }
            } else if (value.startsWith(this.localRepositoryBasedir)) {
                this.out.append("@@repo@@").append(value, this.localRepositoryBasedirLength, value.length());
            } else {
                int sIndex = value.indexOf(CLASSSES_WITH_FRONT_SLASH);
                if (sIndex != -1) {
                    String filename = value.substring(sIndex + CLASSSES_WITH_FRONT_SLASH.length() + 1);
                    Utils.copyFile((File)new File(value), (File)new File("build-gant/flex-configs/" + filename));
                    this.out.append("@@configs@@/").append(filename);
                } else {
                    this.target(value);
                }
            }
            this.out.append("</").append(name).append('>');
            return;
        } else {
            if (name.equals("local-fonts-snapshot")) {
                value = "@@repo@@/fonts.ser";
            }
            super.writeTag(indent, name, value, parentName);
        }
    }

    private void target(String value) {
        this.out.append("@@target@@").append(value, ShareableFlexConfigGenerator.lastSlashIndex(value), value.length());
    }

    private static int lastSlashIndex(String value) {
        int index = value.lastIndexOf(47);
        return index == -1 ? value.lastIndexOf(92) : index;
    }
}

