/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.maven;

import com.intellij.flex.maven.FlexConfigGenerator;
import com.intellij.flex.maven.Utils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import net.flexmojos.oss.compiler.IASDocConfiguration;
import net.flexmojos.oss.compiler.ICommandLineConfiguration;
import net.flexmojos.oss.compiler.ICompcConfiguration;
import net.flexmojos.oss.compiler.IFlexArgument;
import net.flexmojos.oss.compiler.IFlexConfiguration;
import net.flexmojos.oss.compiler.IMetadataConfiguration;
import net.flexmojos.oss.compiler.IRuntimeSharedLibraryPath;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.project.MavenProject;

public class IdeaConfiguratorFlexmojos5
implements FlexConfigGenerator {
    protected static final String PATH_ELEMENT = "path-element";
    protected static final String FILE_SPECS = "file-specs";
    protected static final String LOCAL_FONTS_SNAPSHOT = "local-fonts-snapshot";
    private static final String FONTS_SER = "fonts.ser";
    protected final MavenSession session;
    protected final StringBuilder out;
    private Build build;
    private String classifier;
    protected final File outputDirectory;
    protected static File sharedFontsSer;
    protected static String sharedFontsSerPath;
    private boolean staticLinkRuntimeSharedLibrariesSpecified;

    public IdeaConfiguratorFlexmojos5(MavenSession session, File outputDirectory) {
        this.session = session;
        this.outputDirectory = outputDirectory;
        this.out = new StringBuilder(8192);
        this.out.append("<flex-config xmlns=\"http://www.adobe.com/2006/flex-config\">");
    }

    public void generate(Mojo configuration, File sourceFile) throws Exception {
        this.build(configuration, ICommandLineConfiguration.class, "\n\t", null);
        this.out.append("\n\t<file-specs>\n");
        this.writeTag("\t", PATH_ELEMENT, sourceFile.getAbsolutePath(), FILE_SPECS);
        this.out.append("\n\t</file-specs>");
    }

    public void generate(Mojo configuration) throws Exception {
        this.build(configuration, ICompcConfiguration.class, "\n\t", null);
    }

    public void preGenerate(MavenProject project, String classifier) throws IOException {
        this.classifier = classifier;
        this.build = project.getBuild();
    }

    public String postGenerate(MavenProject project) throws IOException {
        if (!this.staticLinkRuntimeSharedLibrariesSpecified) {
            this.out.append("\n<static-link-runtime-shared-libraries>false</static-link-runtime-shared-libraries>");
        }
        this.out.append("\n</flex-config>");
        String configFile = this.getConfigFilePath(project, this.classifier);
        Utils.write((StringBuilder)this.out, (File)new File(this.outputDirectory, configFile));
        return configFile;
    }

    protected String getConfigFilePath(MavenProject project, String classifier) {
        StringBuilder pathBuilder = new StringBuilder(32).append(project.getArtifactId()).append('-').append(project.getGroupId());
        if (classifier != null) {
            pathBuilder.append('-').append(classifier);
        }
        return pathBuilder.append(".xml").toString();
    }

    /*
     * Could not resolve type clashes
     */
    private <E> void build(E configuration, Class<?> configClass, String indent, String configurationName) throws Exception {
        boolean parentTagWritten = configurationName == null;
        Method[] methods = configClass.getMethods();
        Arrays.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Method method : methods) {
            Object[] values;
            Object value;
            String methodName;
            method.setAccessible(true);
            if (method.getParameterTypes().length != 0 || (methodName = method.getName()).equals("getLoadConfig") || methodName.equals("getDumpConfig") || "metadata".equals(configurationName) && methodName.equals("getDate") || (value = method.invoke(configuration, new Object[0])) == null || (methodName.equals("getFixedLiteralVector") || methodName.equals("getHeadlessServer")) && !((Boolean)value).booleanValue()) continue;
            if (!this.staticLinkRuntimeSharedLibrariesSpecified && methodName.equals("getStaticLinkRuntimeSharedLibraries")) {
                this.staticLinkRuntimeSharedLibrariesSpecified = true;
            }
            if (!parentTagWritten) {
                parentTagWritten = true;
                this.out.append(indent, 0, indent.length() - 1).append('<').append(configurationName).append('>');
            }
            Class<?> returnType = method.getReturnType();
            String name = IdeaConfiguratorFlexmojos5.camelCaseToSnake(methodName, true);
            if (value instanceof IFlexConfiguration) {
                this.build(value, returnType, indent + '\t', name.substring(0, name.length() - 14));
                continue;
            }
            if (configuration instanceof IASDocConfiguration && "footer".equals(name)) {
                throw new UnsupportedOperationException();
            }
            if (value instanceof IRuntimeSharedLibraryPath || value instanceof IRuntimeSharedLibraryPath[]) {
                values = returnType.isArray() ? (IRuntimeSharedLibraryPath[])value : new IRuntimeSharedLibraryPath[]{(IRuntimeSharedLibraryPath)value};
                for (IRuntimeSharedLibraryPath arg : values) {
                    this.out.append("\n\t<").append(name).append(">\n\t\t<path-element>").append(arg.pathElement()).append("</path-element>");
                    for (Map.Entry entry : arg.rslUrl().entrySet()) {
                        this.out.append("\n\t\t<rsl-url>").append((String)entry.getKey()).append("</rsl-url>");
                        if (entry.getValue() == null) continue;
                        this.out.append("\n\t\t<policy-file-url>").append((String)entry.getValue()).append("</policy-file-url>");
                    }
                    this.out.append("\n\t</").append(name).append('>');
                }
                continue;
            }
            if (value instanceof IFlexArgument || value instanceof IFlexArgument[]) {
                Class<?> type = returnType;
                if (type.isArray()) {
                    values = (IFlexArgument[])value;
                    type = returnType.getComponentType();
                } else {
                    values = new IFlexArgument[]{(IFlexArgument)value};
                    type = returnType;
                }
                String[] order = (String[])type.getField("ORDER").get(returnType);
                for (IRuntimeSharedLibraryPath iFlexArgument : values) {
                    this.out.append(indent).append('<').append(name).append('>');
                    for (String argMethodName : order) {
                        Object argValue = type.getDeclaredMethod(argMethodName, new Class[0]).invoke((Object)iFlexArgument, new Object[0]);
                        if (argValue instanceof Collection || argValue.getClass().isArray()) {
                            Object[] subValues;
                            for (Object subArgValue : subValues = argValue.getClass().isArray() ? (Object[])argValue : ((Collection)argValue).toArray()) {
                                this.writeTag(indent, argMethodName, subArgValue.toString(), name);
                            }
                            continue;
                        }
                        if (argValue instanceof Map) {
                            Map map = (Map)argValue;
                            for (Map.Entry argValue1 : map.entrySet()) {
                                Map.Entry entry = argValue1;
                                if (entry.getValue() == null) continue;
                                this.writeTag(indent, (String)entry.getKey(), entry.getValue().toString(), name);
                            }
                            continue;
                        }
                        if (argValue == null) continue;
                        String xmlSrgMethodName = argMethodName.equals("serialNumber") || name.equals("default-script-limits") ? IdeaConfiguratorFlexmojos5.camelCaseToSnake(argMethodName, false) : argMethodName;
                        this.writeTag(indent, xmlSrgMethodName, (String)argValue, name);
                    }
                    this.out.append(indent).append("</").append(name).append('>');
                }
                continue;
            }
            if (name.equals("load-externs") || configuration instanceof IMetadataConfiguration && (name.equals("language") || name.equals("creator") || name.equals("publisher") || name.equals("contributor"))) {
                for (String v : (String[])value) {
                    this.out.append(indent).append('<').append(name).append('>').append(v).append("</").append(name).append('>');
                }
                continue;
            }
            if (returnType.isArray() || value instanceof Collection) {
                Object[] objectArray = values = returnType.isArray() ? (Object[])value : ((Collection)value).toArray();
                if (values.length == 0) {
                    if (!name.equals("theme") && !name.equals("locale")) continue;
                    this.out.append(indent).append('<').append(name).append("/>");
                    continue;
                }
                this.out.append(indent).append('<').append(name).append('>');
                String childTagName = (String)Utils.CHILD_TAG_NAME_MAP.get(name);
                if (childTagName == null) {
                    childTagName = PATH_ELEMENT;
                }
                for (IRuntimeSharedLibraryPath v : values) {
                    if (v == null) {
                        System.out.print('\n' + childTagName + " child value for " + name + " is null\n");
                        continue;
                    }
                    this.writeTag(indent, childTagName, v.toString(), name);
                }
                this.out.append(indent).append("</").append(name).append('>');
                continue;
            }
            this.out.append(indent).append('<').append(name).append('>');
            this.processValue(value.toString(), name);
            this.out.append("</").append(name).append('>');
        }
        if (parentTagWritten && configurationName != null) {
            this.out.append(indent, 0, indent.length() - 1).append("</").append(configurationName).append('>');
        }
    }

    protected void processValue(String value, String name) throws IOException {
        if (name.equals(LOCAL_FONTS_SNAPSHOT)) {
            String defaultPath;
            File fontsSer = new File(this.build.getOutputDirectory(), FONTS_SER);
            try {
                defaultPath = fontsSer.getCanonicalPath();
            }
            catch (IOException e) {
                defaultPath = fontsSer.getAbsolutePath();
            }
            if (value.equals(defaultPath)) {
                if (sharedFontsSerPath == null) {
                    sharedFontsSer = new File(this.outputDirectory, FONTS_SER);
                    sharedFontsSerPath = sharedFontsSer.getPath();
                    if (!sharedFontsSer.exists()) {
                        Utils.copyFile((File)fontsSer, (File)sharedFontsSer);
                    }
                }
                value = sharedFontsSerPath;
            }
        }
        this.out.append(value);
    }

    protected void writeTag(String indent, String name, String value, String parentName) throws IOException {
        this.out.append(indent).append("\t<").append(name).append('>').append(value).append("</").append(name).append('>');
    }

    private static String camelCaseToSnake(String s, boolean removePrefix) {
        StringBuilder builder = new StringBuilder(s.length() + 4);
        int n = s.length();
        for (int i = removePrefix ? IdeaConfiguratorFlexmojos5.removePrefix(s) : 0; i < n; ++i) {
            char c = s.charAt(i);
            if (Character.isUpperCase(c)) {
                builder.append('-').append(Character.toLowerCase(c));
                continue;
            }
            builder.append(c);
        }
        return builder.substring(builder.charAt(0) == '-' ? 1 : 0);
    }

    private static int removePrefix(String s) {
        int cut = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isUpperCase(s.charAt(i))) continue;
            cut = i;
            break;
        }
        return cut;
    }
}

