/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.run.remote;

import com.intellij.dmserver.run.DMRunConfigurationEditorBase;
import com.intellij.dmserver.run.remote.DMServerRemoteModel;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.transport.TransportManager;
import com.intellij.javaee.transport.TransportManagerConfigurable;
import com.intellij.javaee.transport.TransportTarget;
import com.intellij.javaee.transport.TransportTargetConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class DMRemoteRunConfigurationEditor
extends DMRunConfigurationEditorBase {
    private JPanel myRootPanel;
    private JTextField myJmxPortField;
    private JTextField myJmxUserField;
    private JTextField myJmxPasswordField;
    private JTextField myJmxMappingUrlField;
    private JButton myPingButton;
    private TransportManagerConfigurable myTransportManagerConfigurable;
    private TransportTargetConfigurable myDeploymentTransportTargetConfigurable;
    private TransportTargetConfigurable myRepositoryTransportTargetConfigurable;
    private JTextField myRepositoryTargetNameField;
    private JPanel myTransportManagerPanel;
    private JPanel myDeploymentTransportTargetPanel;
    private JPanel myRepositoryTransportTargetPanel;
    private TransportTarget myDeploymentTransportTarget;
    private TransportTarget myRepositoryTransportTarget;

    public DMRemoteRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dmserver/run/remote/DMRemoteRunConfigurationEditor", "<init>"));
        }
        super(project);
        this.$$$setupUI$$$();
        this.myPingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DMRemoteRunConfigurationEditor.this.onPingButton();
            }
        });
        this.getDeploymentTransportTargetConfigurable().setParentConfigurable(this.getTransportManagerConfigurable());
        this.getRepositoryTransportTargetConfigurable().setParentConfigurable(this.getTransportManagerConfigurable());
    }

    private TransportManagerConfigurable getTransportManagerConfigurable() {
        if (this.myTransportManagerConfigurable == null) {
            this.myTransportManagerConfigurable = new TransportManagerConfigurable();
        }
        return this.myTransportManagerConfigurable;
    }

    private TransportTargetConfigurable getDeploymentTransportTargetConfigurable() {
        if (this.myDeploymentTransportTargetConfigurable == null) {
            this.myDeploymentTransportTargetConfigurable = new TransportTargetConfigurable();
        }
        return this.myDeploymentTransportTargetConfigurable;
    }

    private TransportTargetConfigurable getRepositoryTransportTargetConfigurable() {
        if (this.myRepositoryTransportTargetConfigurable == null) {
            this.myRepositoryTransportTargetConfigurable = new TransportTargetConfigurable();
        }
        return this.myRepositoryTransportTargetConfigurable;
    }

    private void onPingButton() {
        Ref success = new Ref(null);
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                CommonModel commonModel = (CommonModel)this.getSnapshot();
                DMServerRemoteModel serverModel = (DMServerRemoteModel)commonModel.getServerModel();
                success.set((Object)serverModel.createServerInstance().connect());
            }
            catch (Exception ex) {
                success.set((Object)false);
            }
        }, DmServerBundle.message("DMRemoteRunConfigurationEditor.message.ping.operation-name", new Object[0]), true, this.getProject())) {
            return;
        }
        if (success.isNull()) {
            return;
        }
        String ping = DmServerBundle.message("DMRemoteRunConfigurationEditor.message.ping", new Object[0]);
        if (((Boolean)success.get()).booleanValue()) {
            Messages.showInfoMessage((String)DmServerBundle.message("DMRemoteRunConfigurationEditor.message.ping.ok", new Object[0]), (String)ping);
        } else {
            Messages.showErrorDialog((String)DmServerBundle.message("DMRemoteRunConfigurationEditor.message.ping.failed", new Object[0]), (String)ping);
        }
    }

    protected void resetEditorFrom(CommonModel s) {
        DMServerRemoteModel serverModel = (DMServerRemoteModel)s.getServerModel();
        this.resetJmxConfiguration(serverModel);
        this.myJmxMappingUrlField.setText(DMRemoteRunConfigurationEditor.notNull(serverModel.getJmxMappingUrl()));
        this.myRepositoryTargetNameField.setText(DMRemoteRunConfigurationEditor.notNull(serverModel.getRepositoryName()));
        this.getTransportManagerConfigurable().setHostId(serverModel.getTransportHostId(), serverModel.getProject());
        this.myDeploymentTransportTarget = DMRemoteRunConfigurationEditor.getOrCreateTransportTarget(serverModel.getTransportTargetJmx());
        this.getDeploymentTransportTargetConfigurable().setTarget(this.myDeploymentTransportTarget);
        this.myRepositoryTransportTarget = DMRemoteRunConfigurationEditor.getOrCreateTransportTarget(serverModel.getTransportTargetRepository());
        this.getRepositoryTransportTargetConfigurable().setTarget(this.myRepositoryTransportTarget);
    }

    private void createUIComponents() {
        this.myTransportManagerPanel = this.getTransportManagerConfigurable().getMainPanel();
        this.myDeploymentTransportTargetPanel = this.getDeploymentTransportTargetConfigurable().getMainPanel();
        this.myRepositoryTransportTargetPanel = this.getRepositoryTransportTargetConfigurable().getMainPanel();
    }

    private static TransportTarget getOrCreateTransportTarget(TransportTarget target) {
        return target == null || target.getId() == null ? TransportManager.createTarget() : target;
    }

    protected void applyEditorTo(CommonModel s) throws ConfigurationException {
        DMServerRemoteModel serverModel = (DMServerRemoteModel)s.getServerModel();
        this.applyJmxConfiguration(serverModel);
        serverModel.setJmxMappingUrl(this.myJmxMappingUrlField.getText());
        serverModel.setRepositoryName(this.myRepositoryTargetNameField.getText());
        serverModel.setTransportHostId(this.getTransportManagerConfigurable().getHostId());
        serverModel.setTransportTargetJmx(this.myDeploymentTransportTarget);
        serverModel.setTransportTargetRepository(this.myRepositoryTransportTarget);
        this.getDeploymentTransportTargetConfigurable().saveState();
        this.getRepositoryTransportTargetConfigurable().saveState();
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/run/remote/DMRemoteRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }

    @Override
    protected JTextField getJmxPortField() {
        return this.myJmxPortField;
    }

    @Override
    protected JTextField getJmxUserField() {
        return this.myJmxUserField;
    }

    @Override
    protected JTextField getJmxPasswordField() {
        return this.myJmxPasswordField;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JButton jButton;
        JTextField jTextField3;
        JTextField jTextField4;
        JTextField jTextField5;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(5, 5, 5, 5), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMRemoteRunConfigurationEditor.jmx.port"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myJmxPortField = jTextField5 = new JTextField();
        jPanel.add((Component)jTextField5, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myJmxUserField = jTextField4 = new JTextField();
        jPanel.add((Component)jTextField4, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myJmxPasswordField = jTextField3 = new JTextField();
        jPanel.add((Component)jTextField3, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMRemoteRunConfigurationEditor.jmx.user"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMRemoteRunConfigurationEditor.jmx.password"));
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPingButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMRemoteRunConfigurationEditor.message.ping"));
        jPanel.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 1, 1, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMRemoteRunConfigurationEditor.remote.staging"), (int)0, (int)0, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMRemoteRunConfigurationEditor.deployment.access"));
        jPanel3.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel3.add((Component)jSeparator, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel4, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 1));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMRemoteRunConfigurationEditor.deployment.access.target"), (int)0, (int)0, null, null));
        JPanel jPanel5 = this.myDeploymentTransportTargetPanel;
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMRemoteRunConfigurationEditor.repository.access"));
        jPanel6.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JSeparator jSeparator2 = new JSeparator();
        jPanel6.add((Component)jSeparator2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 6, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel7, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null, 1));
        jPanel7.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMRemoteRunConfigurationEditor.repository.access.target"), (int)0, (int)0, null, null));
        JPanel jPanel8 = this.myRepositoryTransportTargetPanel;
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMRemoteRunConfigurationEditor.mapped.as"));
        jLabel6.setToolTipText(ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMRemoteRunConfigurationEditor.tooltip.mapped.as"));
        jPanel2.add((Component)jLabel6, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myJmxMappingUrlField = jTextField2 = new JTextField();
        jTextField2.setText("");
        jPanel2.add((Component)jTextField2, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMRemoteRunConfigurationEditor.repository.access.name"));
        jPanel2.add((Component)jLabel7, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRepositoryTargetNameField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(6, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel9 = this.myTransportManagerPanel;
        jPanel2.add((Component)jPanel9, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jLabel.setLabelFor(jTextField5);
        jLabel2.setLabelFor(jTextField4);
        jLabel3.setLabelFor(jTextField3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

