/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.run;

import com.intellij.dmserver.artifacts.DMBundleArtifactType;
import com.intellij.dmserver.artifacts.DMParArtifactType;
import com.intellij.dmserver.artifacts.DMPlanArtifactType;
import com.intellij.dmserver.artifacts.ManifestManager;
import com.intellij.dmserver.artifacts.WithModuleArtifactUtil;
import com.intellij.dmserver.deploy.DMServerDeploymentProvider;
import com.intellij.dmserver.facet.DMCompositeFacet;
import com.intellij.dmserver.facet.NestedUnitIdentity;
import com.intellij.dmserver.install.DMServerInstallation;
import com.intellij.dmserver.integration.DMServerIntegrationData;
import com.intellij.dmserver.run.DMServerInstance;
import com.intellij.dmserver.util.ManifestUtils;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.javaee.appServerIntegrations.ApplicationServerUrlMapping;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.ServerModel;
import com.intellij.javaee.run.execution.DefaultOutputProcessor;
import com.intellij.javaee.run.execution.OutputProcessor;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.psi.PsiFile;
import com.intellij.util.xmlb.annotations.Tag;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DMServerModelBase
implements ServerModel {
    private CommonModel myCommonModel;
    private int myPort = 8080;
    private String myMBeanServerUserName = "admin";
    private int myMBeanServerPort = 9875;
    private String myMBeanServerPassword = "springsource";

    public final void setCommonModel(CommonModel commonModel) {
        this.myCommonModel = commonModel;
    }

    public abstract boolean prepareDeploy(VirtualFile var1);

    public abstract URL computeServerAccessibleStagingURL(String var1) throws MalformedURLException;

    public abstract boolean addToRepository(List<VirtualFile> var1);

    public abstract boolean removeFromRepository(List<VirtualFile> var1);

    @Nullable
    public abstract String getRepositoryName();

    public final boolean isLocal() {
        return this.myCommonModel.isLocal();
    }

    public final CommonModel getCommonModel() {
        return this.myCommonModel;
    }

    public final Project getProject() {
        return this.getCommonModel().getProject();
    }

    public final J2EEServerInstance createServerInstance() throws ExecutionException {
        DMServerIntegrationData integrationData = (DMServerIntegrationData)this.getCommonModel().getApplicationServer().getPersistentData();
        DMServerInstallation installation = integrationData.getInstallation();
        if (installation == null) {
            throw new ExecutionException("Can not locate dmServer home");
        }
        if (!installation.isValid()) {
            throw new ExecutionException("Can not locate dmServer startup/shutdown script");
        }
        return new DMServerInstance(this.myCommonModel, installation.getServerVersion());
    }

    public final DeploymentProvider getDeploymentProvider() {
        return new DMServerDeploymentProvider();
    }

    public int getDefaultPort() {
        return 8080;
    }

    @NotNull
    @NonNls
    public String getDefaultUrlForBrowser() {
        ApplicationServerUrlMapping urlMapping = (ApplicationServerUrlMapping)this.myCommonModel.getIntegration().getDeployedFileUrlProvider();
        String webContext = this.searchWebContext(this.myCommonModel.getDeployedArtifacts());
        String string = urlMapping.getDefaultUrlForServerConfig(this.myCommonModel) + StringUtil.notNullize((String)webContext);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/run/DMServerModelBase", "getDefaultUrlForBrowser"));
        }
        return string;
    }

    public String searchWebContext(List<Artifact> artifacts) {
        String context = null;
        for (Artifact artifact : artifacts) {
            Module module = WithModuleArtifactUtil.findModuleFor(this.myCommonModel.getProject(), artifact);
            ArtifactType artifactType = artifact.getArtifactType();
            if (artifactType == DMBundleArtifactType.getInstance()) {
                if (module == null) {
                    return null;
                }
                ManifestManager.FileWrapper manifestFile = ManifestManager.getBundleInstance().findManifest(module);
                if (manifestFile == null) {
                    return null;
                }
                context = ManifestUtils.getInstance().getHeaderValue((PsiFile)manifestFile.getFile(), "Web-ContextPath");
            }
            if (artifactType != DMPlanArtifactType.getInstance() && artifactType != DMParArtifactType.getInstance()) continue;
            DMCompositeFacet facet = DMCompositeFacet.getInstance(module);
            if (facet == null) {
                return null;
            }
            List nestedUnitIdentities = (List)facet.getConfigurationImpl().getNestedBundles();
            for (NestedUnitIdentity nest : nestedUnitIdentities) {
                List<Artifact> nestArtifacts = WithModuleArtifactUtil.findWithModuleArtifactsFor(nest.getModule());
                context = this.searchWebContext(nestArtifacts);
            }
            if (context != null) continue;
            return null;
        }
        return context;
    }

    public OutputProcessor createOutputProcessor(ProcessHandler processHandler, J2EEServerInstance serverInstance) {
        return new DefaultOutputProcessor(processHandler);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int getLocalPort() {
        return this.myPort;
    }

    public void setPort(int port) {
        this.myPort = port;
    }

    public String getMBeanServerUserName() {
        return this.myMBeanServerUserName;
    }

    public void setMBeanServerUserName(String beanServerUserName) {
        this.myMBeanServerUserName = beanServerUserName;
    }

    public int getMBeanServerPort() {
        return this.myMBeanServerPort;
    }

    public void setMBeanServerPort(int beanServerPort) {
        this.myMBeanServerPort = beanServerPort;
    }

    public String getMBeanServerPassword() {
        return this.myMBeanServerPassword;
    }

    public void setMBeanServerPassword(String beanServerPassword) {
        this.myMBeanServerPassword = beanServerPassword;
    }

    protected void readFromSettingsBase(DMServerModelSettingsBase settings) {
        this.myPort = settings.getPort();
        this.myMBeanServerUserName = settings.getMBeanUserName();
        this.myMBeanServerPassword = settings.getMBeanPassword();
        this.myMBeanServerPort = settings.getMBeanPort();
    }

    protected void writeToSettingsBase(DMServerModelSettingsBase settings) {
        settings.setPort(this.myPort);
        settings.setMBeanPassword(this.myMBeanServerPassword);
        settings.setMBeanUserName(this.myMBeanServerUserName);
        settings.setMBeanPort(this.myMBeanServerPort);
    }

    public static abstract class DMServerModelSettingsBase {
        @Tag(value="port")
        private int myPort = 8080;
        @Tag(value="mbean-port")
        private int myMBeanPort;
        @Tag(value="mbean-user")
        private String myMBeanUserName;
        @Tag(value="mbean-password")
        private String myMBeanPassword;

        public int getPort() {
            return this.myPort;
        }

        public void setPort(int port) {
            this.myPort = port;
        }

        public int getMBeanPort() {
            return this.myMBeanPort;
        }

        public void setMBeanPort(int mBeanPort) {
            this.myMBeanPort = mBeanPort;
        }

        public String getMBeanUserName() {
            return this.myMBeanUserName;
        }

        public void setMBeanUserName(String mBeanUserName) {
            this.myMBeanUserName = mBeanUserName;
        }

        public String getMBeanPassword() {
            return this.myMBeanPassword;
        }

        public void setMBeanPassword(String mBeanPassword) {
            this.myMBeanPassword = mBeanPassword;
        }
    }
}

