/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.run;

import com.intellij.dmserver.integration.DMServerIntegrationData;
import com.intellij.dmserver.integration.DMServerRepositoryItem;
import com.intellij.dmserver.integration.DMServerRepositoryWatchedItem;
import com.intellij.dmserver.run.DMRunConfigurationEditorBase;
import com.intellij.dmserver.run.DMServerModel;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.run.configuration.ApplicationServerSelectionListener;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DMLocalRunConfigurationEditor
extends DMRunConfigurationEditorBase
implements ApplicationServerSelectionListener,
PanelWithAnchor {
    private JPanel myRootPanel;
    private JTextField myPortField;
    private JTextField myJmxPortField;
    private JTextField myJmxUserField;
    private JTextField myJmxPasswordField;
    private JComboBox myRepositoryItemComboBox;
    private JBLabel myJMXPasswordLabel;
    private JComponent anchor;
    private final DMServerModel myModel;

    public DMLocalRunConfigurationEditor(Project project, DMServerModel model) {
        super(project);
        this.myModel = model;
        this.$$$setupUI$$$();
        this.myRepositoryItemComboBox.setRenderer(new ListCellRendererWrapper<DMServerRepositoryWatchedItem>(){

            public void customize(JList list, DMServerRepositoryWatchedItem value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText(value.getPath());
                }
            }
        });
        this.serverSelected(model.getCommonModel().getApplicationServer());
        this.setAnchor((JComponent)this.myJMXPasswordLabel);
    }

    @Override
    protected JTextField getJmxPortField() {
        return this.myJmxPortField;
    }

    @Override
    protected JTextField getJmxUserField() {
        return this.myJmxUserField;
    }

    @Override
    protected JTextField getJmxPasswordField() {
        return this.myJmxPasswordField;
    }

    protected void resetEditorFrom(CommonModel s) {
        DMServerModel serverModel = (DMServerModel)s.getServerModel();
        this.myPortField.setText(String.valueOf(serverModel.getLocalPort()));
        String repositoryFolder = serverModel.getTargetRepositoryFolder();
        if (repositoryFolder != null) {
            for (int i = 0; i < this.myRepositoryItemComboBox.getItemCount(); ++i) {
                DMServerRepositoryWatchedItem repositoryItem = (DMServerRepositoryWatchedItem)this.myRepositoryItemComboBox.getItemAt(i);
                if (!repositoryFolder.equals(repositoryItem.getPath())) continue;
                this.myRepositoryItemComboBox.setSelectedItem(repositoryItem);
                break;
            }
        }
        this.resetJmxConfiguration(serverModel);
    }

    protected void applyEditorTo(CommonModel s) throws ConfigurationException {
        DMServerModel serverModel = (DMServerModel)s.getServerModel();
        serverModel.setPort(DMLocalRunConfigurationEditor.parseInt(this.myPortField, "DMLocalRunConfigurationEditor.bad.port"));
        DMServerRepositoryWatchedItem selectedRepositoryItem = (DMServerRepositoryWatchedItem)this.myRepositoryItemComboBox.getSelectedItem();
        serverModel.setTargetRepositoryFolder(selectedRepositoryItem == null ? null : selectedRepositoryItem.getPath());
        this.applyJmxConfiguration(serverModel);
    }

    public void serverSelected(@Nullable ApplicationServer server) {
        this.myRepositoryItemComboBox.removeAllItems();
        if (server != null) {
            DMServerIntegrationData integrationData = (DMServerIntegrationData)server.getPersistentData();
            for (DMServerRepositoryItem repositoryItem : integrationData.getRepositoryItems()) {
                if (!(repositoryItem instanceof DMServerRepositoryWatchedItem)) continue;
                this.myRepositoryItemComboBox.addItem(repositoryItem);
            }
        }
    }

    public void serverProbablyEdited(@Nullable ApplicationServer server) {
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/run/DMLocalRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myJMXPasswordLabel.setAnchor(anchor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JBLabel jBLabel;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMLocalRunConfigurationEditor.port"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPortField = jTextField4 = new JTextField();
        jPanel.add((Component)jTextField4, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMLocalRunConfigurationEditor.jmx.port"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myJmxPortField = jTextField3 = new JTextField();
        jPanel.add((Component)jTextField3, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myJmxUserField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myJmxPasswordField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMLocalRunConfigurationEditor.jmx.user"));
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myJMXPasswordLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMLocalRunConfigurationEditor.jmx.password"));
        jPanel.add((Component)jBLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMLocalRunConfigurationEditor.local.staging"), (int)0, (int)0, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMLocalRunConfigurationEditor.local.staging.repository.target"));
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRepositoryItemComboBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        jLabel2.setLabelFor(jTextField4);
        jLabel3.setLabelFor(jTextField2);
        jBLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

