/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.osmorc;

import com.intellij.dmserver.install.impl.DMServerInstallationImpl;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkInstanceManager;
import org.osmorc.run.ui.SelectedBundle;

public class DMServerFrameworkInstanceManager
implements FrameworkInstanceManager {
    private final LocalFileSystem myFileSystem;

    public DMServerFrameworkInstanceManager(LocalFileSystem fileSystem) {
        this.myFileSystem = fileSystem;
    }

    @NotNull
    public Collection<SelectedBundle> getFrameworkBundles(@NotNull FrameworkInstanceDefinition instance, @NotNull FrameworkInstanceManager.FrameworkBundleType type) {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/dmserver/osmorc/DMServerFrameworkInstanceManager", "getFrameworkBundles"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/dmserver/osmorc/DMServerFrameworkInstanceManager", "getFrameworkBundles"));
        }
        List<SelectedBundle> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/osmorc/DMServerFrameworkInstanceManager", "getFrameworkBundles"));
        }
        return list;
    }

    public String checkValidity(@NotNull FrameworkInstanceDefinition frameworkInstanceDefinition) {
        if (frameworkInstanceDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkInstanceDefinition", "com/intellij/dmserver/osmorc/DMServerFrameworkInstanceManager", "checkValidity"));
        }
        String instanceName = frameworkInstanceDefinition.getName();
        if (instanceName == null || instanceName.trim().length() == 0) {
            return DmServerBundle.message("DMServerFrameworkInstanceManager.error.instance.name.required", new Object[0]);
        }
        VirtualFile serverRootFolder = this.myFileSystem.findFileByPath(frameworkInstanceDefinition.getBaseFolder());
        if (serverRootFolder == null || !serverRootFolder.isDirectory()) {
            return DmServerBundle.message("DMServerFrameworkInstanceManager.error.folder.not.exists.or.not.folder", frameworkInstanceDefinition.getBaseFolder());
        }
        ValidationResult installationValid = new DMServerInstallationImpl(serverRootFolder).validate();
        if (!installationValid.isOk()) {
            return installationValid.getErrorMessage();
        }
        return null;
    }
}

