/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.libraries;

import com.intellij.dmserver.install.DMServerInstallation;
import com.intellij.dmserver.libraries.LibrariesDialog;
import com.intellij.dmserver.libraries.ServerLibrariesContext;
import com.intellij.dmserver.osmorc.FrameworkUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;

public class LibrariesDialogCreator {
    private static final LibrariesDialogCreator ourInstance = new LibrariesDialogCreator();

    private LibrariesDialogCreator() {
    }

    public static LibrariesDialogCreator getInstance() {
        return ourInstance;
    }

    public static boolean isDialogAvailable(Project project) {
        final Ref result = new Ref((Object)false);
        new Checker(){

            @Override
            protected void onAvailable(FrameworkInstanceDefinition framework, DMServerInstallation installation) {
                result.set((Object)true);
            }
        }.check(project);
        return (Boolean)result.get();
    }

    public static void showDialog(final Project project, final @Nullable String packageName) {
        new Checker(){

            @Override
            protected void onAvailable(FrameworkInstanceDefinition framework, DMServerInstallation installation) {
                LibrariesDialog dialog = LibrariesDialogCreator.createDialog(framework, project, installation);
                if (packageName != null) {
                    dialog.initSearch(packageName);
                }
                dialog.show();
            }
        }.check(project);
    }

    public static LibrariesDialog createDialog(@NotNull FrameworkInstanceDefinition framework, Project project, @NotNull DMServerInstallation installation) {
        if (framework == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "framework", "com/intellij/dmserver/libraries/LibrariesDialogCreator", "createDialog"));
        }
        if (installation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installation", "com/intellij/dmserver/libraries/LibrariesDialogCreator", "createDialog"));
        }
        ServerLibrariesContext context = new ServerLibrariesContext(framework, project, installation);
        return new LibrariesDialog(context);
    }

    private static abstract class Checker {
        private Checker() {
        }

        public void check(Project project) {
            FrameworkInstanceDefinition framework = FrameworkUtils.getInstance().getActiveFrameworkInstance(project);
            if (framework == null) {
                return;
            }
            DMServerInstallation installation = FrameworkUtils.getInstance().getDMServerInstallation(framework);
            if (installation == null) {
                return;
            }
            this.onAvailable(framework, installation);
        }

        protected abstract void onAvailable(FrameworkInstanceDefinition var1, DMServerInstallation var2);
    }
}

