/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.libraries;

import com.intellij.CommonBundle;
import com.intellij.dmserver.editor.AvailableBundlesProvider;
import com.intellij.dmserver.libraries.ServerLibrariesContext;
import com.intellij.dmserver.libraries.ServerLibrariesUI;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibrariesDialog
extends DialogWrapper {
    private final ServerLibrariesUI myUI;
    private final Project myProject;

    public LibrariesDialog(ServerLibrariesContext context) {
        super(context.getProject(), true);
        this.myUI = new ServerLibrariesUI(context);
        this.myProject = context.getProject();
        this.setTitle(DmServerBundle.message("LibrariesDialog.title", new Object[0]));
        this.setOKButtonText(CommonBundle.getCloseButtonText());
        this.init();
    }

    public void show() {
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> AvailableBundlesProvider.getInstance(this.myProject).resetRepositoryIndex(), DmServerBundle.message("LibrariesDialog.progress.updating.index", new Object[0]), true, this.myProject)) {
            return;
        }
        super.show();
    }

    protected JComponent createCenterPanel() {
        return this.myUI;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/libraries/LibrariesDialog", "createActions"));
        }
        return actionArray;
    }

    public void initSearch(String packageName) {
        this.myUI.initSearch(packageName);
    }

    protected void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myUI);
    }

    @Nullable
    @NonNls
    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

