/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.intention;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.dmserver.facet.DMBundleFacet;
import com.intellij.dmserver.intention.BundleResolver;
import com.intellij.dmserver.intention.LibraryResolver;
import com.intellij.dmserver.intention.PackageResolver;
import com.intellij.dmserver.intention.UnitResolver;
import com.intellij.dmserver.manifest.HeaderValuePartDispatcher;
import com.intellij.dmserver.manifest.HeaderValuePartProcessor;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class UnknownImportedPackageInspection
extends LocalInspectionTool {
    private static HeaderValuePartDispatcher<ProblemsHolder, UnitResolver> ourUnitResolveDispatcher = new HeaderValuePartDispatcher((HeaderValuePartProcessor[])new UnitResolver[]{new PackageResolver(), new BundleResolver(), new LibraryResolver()});

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = DmServerBundle.message("UnknownImportedPackageInspection.group-name.osgi", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/intention/UnknownImportedPackageInspection", "getGroupDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/intention/UnknownImportedPackageInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = DmServerBundle.message("UnknownImportedPackageInspection.display-name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/intention/UnknownImportedPackageInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("dmserverUnknownImportedPackage" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/intention/UnknownImportedPackageInspection", "getShortName"));
        }
        return "dmserverUnknownImportedPackage";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/dmserver/intention/UnknownImportedPackageInspection", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
                if (module == null || DMBundleFacet.getInstance(module) == null) {
                    return;
                }
                ourUnitResolveDispatcher.process(element, holder);
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/intention/UnknownImportedPackageInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }
}

