/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.integration;

import com.intellij.dmserver.install.ServerVersionHandler;
import com.intellij.dmserver.integration.DMServerIntegrationData;
import com.intellij.dmserver.integration.DMServerIntegrationEditor;
import com.intellij.dmserver.integration.DMServerRepositoryEditorListener;
import com.intellij.dmserver.integration.DMServerRepositoryFolderDialog;
import com.intellij.dmserver.integration.DMServerRepositoryFolderDialog10;
import com.intellij.dmserver.integration.DMServerRepositoryFolderDialog20;
import com.intellij.dmserver.integration.DMServerRepositoryItem;
import com.intellij.dmserver.integration.DMServerRepositoryItem10;
import com.intellij.dmserver.integration.DMServerRepositoryItem20Base;
import com.intellij.dmserver.libraries.obr.Column;
import com.intellij.dmserver.libraries.obr.JTableWrapper;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;

public class DMServerRepositoryEditor {
    private static final RepositoryItem10ColumnBase[] our10Columns = new RepositoryItem10ColumnBase[]{new RepositoryItem10ColumnBase(DmServerBundle.message("Form.DMServerRepositoryEditor.repository.item.column.10.path", new Object[0])){

        @Override
        public Object getColumnValue(DMServerRepositoryItem10 row) {
            return row.getPath();
        }
    }};
    private static final RepositoryItem20ColumnBase[] our20Columns = new RepositoryItem20ColumnBase[]{new RepositoryItem20ColumnBase(DmServerBundle.message("Form.DMServerRepositoryEditor.repository.item.column.20.type", new Object[0])){

        @Override
        public Object getColumnValue(DMServerRepositoryItem20Base row) {
            return row.getTypePropertyValue();
        }

        @Override
        public boolean needPack() {
            return true;
        }
    }, new RepositoryItem20ColumnBase(DmServerBundle.message("Form.DMServerRepositoryEditor.repository.item.column.20.name", new Object[0])){

        @Override
        public Object getColumnValue(DMServerRepositoryItem20Base row) {
            return row.getName();
        }

        @Override
        public boolean needPack() {
            return true;
        }
    }, new RepositoryItem20ColumnBase(DmServerBundle.message("Form.DMServerRepositoryEditor.repository.item.column.20.path", new Object[0])){

        @Override
        public Object getColumnValue(DMServerRepositoryItem20Base row) {
            return row.getPath();
        }
    }};
    private JPanel myMainPanel;
    private JBTable myPathTable;
    private DMServerIntegrationEditor myParent;
    private final List<Behavior<?>> myPossibleBehaviors = Arrays.asList(new Behavior10(), new Behavior20());
    private Behavior<?> myBehavior;
    private DMServerRepositoryEditorListener myListener;

    public DMServerRepositoryEditor() {
        this.myPathTable = new JBTable();
        this.myMainPanel = ToolbarDecorator.createDecorator((JTable)this.myPathTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                DMServerRepositoryEditor.this.myBehavior.onAdd();
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ((Behavior)DMServerRepositoryEditor.this.myBehavior).onEdit();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ((Behavior)DMServerRepositoryEditor.this.myBehavior).onRemove();
            }
        }).disableUpDownActions().createPanel();
    }

    public void setListener(DMServerRepositoryEditorListener listener) {
        this.myListener = listener;
    }

    private int getSelectedRow() {
        return this.myPathTable.getSelectedRow();
    }

    private void setSelectedRow(int row) {
        this.myPathTable.getSelectionModel().setSelectionInterval(row, row);
    }

    public void applyTo(DMServerIntegrationData data) {
        data.setRepositoryItems(this.getRepositoryItems());
    }

    public void loadFrom(DMServerIntegrationData data, ServerVersionHandler.DMVersion version) {
        for (Behavior<?> behavior : this.myPossibleBehaviors) {
            if (behavior.getVersion() != version) continue;
            this.myBehavior = behavior;
            this.myBehavior.activate(data);
            return;
        }
        this.myBehavior = null;
    }

    public void setParent(DMServerIntegrationEditor parent) {
        this.myParent = parent;
    }

    public DMServerIntegrationEditor getParent() {
        return this.myParent;
    }

    public List<DMServerRepositoryItem> getRepositoryItems() {
        return this.myBehavior == null ? Collections.emptyList() : new ArrayList(this.myBehavior.getRepositoryItems());
    }

    public void setEnabled(boolean enabled) {
        this.myPathTable.setEnabled(enabled);
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    private class Behavior10
    extends Behavior<DMServerRepositoryItem10> {
        private Behavior10() {
        }

        @Override
        public ServerVersionHandler.DMVersion getVersion() {
            return ServerVersionHandler.DMVersion.DM_10;
        }

        @Override
        protected JTableWrapper<DMServerRepositoryItem10, Column<DMServerRepositoryItem10>> createTableWrapper() {
            return new JTableWrapper(DMServerRepositoryEditor.this.myPathTable, (Column[])our10Columns);
        }

        @Override
        protected Class<DMServerRepositoryItem10> getItemClass() {
            return DMServerRepositoryItem10.class;
        }

        @Override
        public DMServerRepositoryFolderDialog<DMServerRepositoryItem10> createItemDialog() {
            return new DMServerRepositoryFolderDialog10(DMServerRepositoryEditor.this);
        }
    }

    private class Behavior20
    extends Behavior<DMServerRepositoryItem20Base> {
        private Behavior20() {
        }

        @Override
        public ServerVersionHandler.DMVersion getVersion() {
            return ServerVersionHandler.DMVersion.DM_20;
        }

        @Override
        protected JTableWrapper<DMServerRepositoryItem20Base, Column<DMServerRepositoryItem20Base>> createTableWrapper() {
            return new JTableWrapper(DMServerRepositoryEditor.this.myPathTable, (Column[])our20Columns);
        }

        @Override
        protected Class<DMServerRepositoryItem20Base> getItemClass() {
            return DMServerRepositoryItem20Base.class;
        }

        @Override
        public DMServerRepositoryFolderDialog<DMServerRepositoryItem20Base> createItemDialog() {
            return new DMServerRepositoryFolderDialog20(DMServerRepositoryEditor.this);
        }
    }

    private abstract class Behavior<T extends DMServerRepositoryItem> {
        private JTableWrapper<T, Column<T>> myTableWrapper;
        private List<T> myRepositoryItems = new ArrayList<T>();

        private Behavior() {
        }

        public List<T> getRepositoryItems() {
            return this.myRepositoryItems;
        }

        public abstract ServerVersionHandler.DMVersion getVersion();

        public abstract DMServerRepositoryFolderDialog<T> createItemDialog();

        public void activate(DMServerIntegrationData data) {
            this.myTableWrapper = this.createTableWrapper();
            this.myRepositoryItems.clear();
            for (DMServerRepositoryItem repositoryItem : data.getRepositoryItems()) {
                if (!this.getItemClass().isInstance(repositoryItem)) continue;
                this.myRepositoryItems.add(this.getItemClass().cast(repositoryItem));
            }
            this.updateTable();
        }

        public void updateTable() {
            this.myTableWrapper.setInputRows(this.myRepositoryItems);
        }

        public void onAdd() {
            DMServerRepositoryFolderDialog<T> itemDialog = this.createItemDialog();
            if (!itemDialog.showAndGet()) {
                return;
            }
            this.myRepositoryItems.add(itemDialog.getItem());
            this.updateTable();
            DMServerRepositoryEditor.this.setSelectedRow(this.myRepositoryItems.size() - 1);
            if (DMServerRepositoryEditor.this.myListener != null) {
                DMServerRepositoryEditor.this.myListener.itemAdded();
            }
        }

        private void onEdit() {
            int selectedRow = DMServerRepositoryEditor.this.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            DMServerRepositoryFolderDialog<T> itemDialog = this.createItemDialog();
            itemDialog.setItem((DMServerRepositoryItem)this.myRepositoryItems.get(selectedRow));
            if (!itemDialog.showAndGet()) {
                return;
            }
            this.myRepositoryItems.set(selectedRow, itemDialog.getItem());
            this.updateTable();
            DMServerRepositoryEditor.this.setSelectedRow(selectedRow);
        }

        private void onRemove() {
            int selectedRow = DMServerRepositoryEditor.this.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            this.myRepositoryItems.remove(selectedRow);
            this.updateTable();
        }

        protected abstract Class<T> getItemClass();

        protected abstract JTableWrapper<T, Column<T>> createTableWrapper();
    }

    private static abstract class RepositoryItem10ColumnBase
    extends Column<DMServerRepositoryItem10> {
        public RepositoryItem10ColumnBase(String name) {
            super(name);
        }
    }

    private static abstract class RepositoryItem20ColumnBase
    extends Column<DMServerRepositoryItem20Base> {
        public RepositoryItem20ColumnBase(String name) {
            super(name);
        }
    }
}

