/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.integration;

import com.intellij.dmserver.install.DMServerInstallation;
import com.intellij.dmserver.integration.DMServerHelper;
import com.intellij.dmserver.integration.DMServerIntegrationData;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.javaee.appServerIntegrations.AppServerDeployedFileUrlProvider;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.appServerIntegrations.ApplicationServerUrlMapping;
import com.intellij.javaee.context.FacetContextProvider;
import com.intellij.javaee.openapi.ex.AppServerIntegrationsManager;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.javaee.web.WebFacetContextProvider;
import icons.DmServerSupportIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DMServerIntegration
extends AppServerIntegration {
    private final DMServerHelper myHelper = new DMServerHelper();
    private ApplicationServerUrlMapping myUrlMapping;

    public static DMServerIntegration getInstance() {
        return (DMServerIntegration)AppServerIntegrationsManager.getInstance().getIntegration(DMServerIntegration.class);
    }

    public Icon getIcon() {
        return DmServerSupportIcons.DM;
    }

    public String getPresentableName() {
        return DmServerBundle.message("DMServerIntegration.name", new Object[0]);
    }

    public DMServerHelper getApplicationServerHelper() {
        return this.myHelper;
    }

    @Nullable
    public DMServerInstallation getServerInstallation(CommonModel commonModel) {
        ApplicationServer server = commonModel.getApplicationServer();
        return server == null ? null : this.getServerInstallation(server);
    }

    public DMServerInstallation getServerInstallation(ApplicationServer applicationServer) {
        if (applicationServer.getSourceIntegration() != this) {
            return null;
        }
        DMServerIntegrationData dataImpl = (DMServerIntegrationData)applicationServer.getPersistentData();
        return dataImpl.getInstallation();
    }

    public List<ApplicationServer> getDMServers() {
        ApplicationServersManager serversManager = ApplicationServersManager.getInstance();
        return serversManager.getApplicationServers(new AppServerIntegration[]{DMServerIntegration.getInstance()});
    }

    @NotNull
    public AppServerDeployedFileUrlProvider getDeployedFileUrlProvider() {
        if (this.myUrlMapping == null) {
            this.myUrlMapping = new ApplicationServerUrlMapping(){

                protected void collectFacetContextProviders(List<FacetContextProvider> facetContextProvider) {
                    facetContextProvider.add((FacetContextProvider)new WebFacetContextProvider());
                }
            };
        }
        ApplicationServerUrlMapping applicationServerUrlMapping = this.myUrlMapping;
        if (applicationServerUrlMapping == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/integration/DMServerIntegration", "getDeployedFileUrlProvider"));
        }
        return applicationServerUrlMapping;
    }
}

