/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.install.impl;

import com.intellij.dmserver.install.DMServerInstallation;
import com.intellij.dmserver.install.DMServerInstallationManager;
import com.intellij.dmserver.install.impl.DMServerInstallationImpl;
import com.intellij.dmserver.integration.DMServerIntegration;
import com.intellij.dmserver.integration.DMServerIntegrationData;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.j2ee.appServerIntegrations.impl.ApplicationServersManagerAdapter;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.javaee.serverInstances.ApplicationServersManagerListener;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.settings.ApplicationSettings;

public class DMServerInstallationManagerImpl
extends DMServerInstallationManager {
    private final Map<String, DMServerInstallation> myInstallations = new THashMap();
    private final ApplicationSettings myApplicationSettings;

    public DMServerInstallationManagerImpl(ApplicationSettings applicationSettings, ApplicationServersManager serversManager) {
        this.myApplicationSettings = applicationSettings;
        serversManager.addServersListener((ApplicationServersManagerListener)new ApplicationServersManagerAdapter(){

            public void serverAdded(@NotNull ApplicationServer server) {
                if (server == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/dmserver/install/impl/DMServerInstallationManagerImpl$1", "serverAdded"));
                }
                AppServerIntegration sourceIntegration = server.getSourceIntegration();
                if (sourceIntegration != null && sourceIntegration instanceof DMServerIntegration) {
                    DMServerInstallationManagerImpl.this.findFramework(((DMServerIntegration)sourceIntegration).getServerInstallation(server));
                }
            }
        });
    }

    @Override
    @NotNull
    public List<? extends DMServerInstallation> getValidInstallations() {
        List servers = ApplicationServersManager.getInstance().getApplicationServers(new AppServerIntegration[]{DMServerIntegration.getInstance()});
        ArrayList<DMServerInstallation> result = new ArrayList<DMServerInstallation>();
        for (ApplicationServer next : servers) {
            DMServerInstallation nextInstall = ((DMServerIntegrationData)next.getPersistentData()).getInstallation();
            if (nextInstall == null || !nextInstall.isValid()) continue;
            result.add(nextInstall);
        }
        ArrayList<DMServerInstallation> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/install/impl/DMServerInstallationManagerImpl", "getValidInstallations"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public DMServerInstallation findInstallation(VirtualFile home) {
        String homePath = FileUtil.toSystemIndependentName((String)home.getPath());
        DMServerInstallation result = this.myInstallations.get(homePath);
        if (result == null) {
            result = new DMServerInstallationImpl(home);
            this.myInstallations.put(homePath, result);
        }
        DMServerInstallation dMServerInstallation = result;
        if (dMServerInstallation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/install/impl/DMServerInstallationManagerImpl", "findInstallation"));
        }
        return dMServerInstallation;
    }

    @Override
    public FrameworkInstanceDefinition findFramework(DMServerInstallation installation) {
        return this.findFramework(installation, true);
    }

    @Override
    public FrameworkInstanceDefinition findFramework(DMServerInstallation installation, boolean create) {
        if (installation == null || !installation.isValid()) {
            return null;
        }
        for (FrameworkInstanceDefinition framework : this.myApplicationSettings.getFrameworkInstanceDefinitions()) {
            VirtualFile frameworkHome;
            if (!"dmServer".equals(framework.getFrameworkIntegratorName()) || (frameworkHome = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)framework.getBaseFolder()))) == null || !frameworkHome.getPath().equals(installation.getHome().getPath())) continue;
            return framework;
        }
        if (!create) {
            return null;
        }
        FrameworkInstanceDefinition newFramework = new FrameworkInstanceDefinition();
        UniqueNameGenerator generator = new UniqueNameGenerator((Collection)this.myApplicationSettings.getFrameworkInstanceDefinitions(), (Function)((NullableFunction)o -> DMServerInstallationManagerImpl.createFrameworkName(o.getName())));
        newFramework.setName(generator.generateUniqueName(DMServerInstallationManagerImpl.createFrameworkName(installation.getOrCreateApplicationServer().getName())));
        newFramework.setFrameworkIntegratorName("dmServer");
        newFramework.setBaseFolder(FileUtil.toSystemDependentName((String)installation.getHome().getPath()));
        this.myApplicationSettings.getFrameworkInstanceDefinitions().add(newFramework);
        return newFramework;
    }

    private static String createFrameworkName(String basicName) {
        return DmServerBundle.message("DMServerInstallationManagerImpl.framework.name", basicName);
    }

    @Override
    @Nullable
    public DMServerInstallation findInstallation(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/dmserver/install/impl/DMServerInstallationManagerImpl", "findInstallation"));
        }
        VirtualFile home = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)homePath));
        return home == null ? null : this.findInstallation(home);
    }

    @Override
    @Nullable
    public DMServerInstallation findInstallation(FrameworkInstanceDefinition framework) {
        return this.findInstallation(framework.getBaseFolder());
    }
}

